/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DiskInfo.getter(DiskInfo::name)).setter(DiskInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(DiskInfo.getter(DiskInfo::path)).setter(DiskInfo.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("sizeInGb").getter(DiskInfo.getter(DiskInfo::sizeInGb)).setter(DiskInfo.setter(Builder::sizeInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sizeInGb").build()}).build();
    private static final SdkField<Boolean> IS_SYSTEM_DISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSystemDisk").getter(DiskInfo.getter(DiskInfo::isSystemDisk)).setter(DiskInfo.setter(Builder::isSystemDisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSystemDisk").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, PATH_FIELD, SIZE_IN_GB_FIELD, IS_SYSTEM_DISK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DiskInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String path;
    private final Integer sizeInGb;
    private final Boolean isSystemDisk;

    private DiskInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.sizeInGb = builder.sizeInGb;
        this.isSystemDisk = builder.isSystemDisk;
    }

    public final String name() {
        return this.name;
    }

    public final String path() {
        return this.path;
    }

    public final Integer sizeInGb() {
        return this.sizeInGb;
    }

    public final Boolean isSystemDisk() {
        return this.isSystemDisk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSystemDisk());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskInfo)) {
            return false;
        }
        DiskInfo other = (DiskInfo)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.sizeInGb(), other.sizeInGb()) && Objects.equals(this.isSystemDisk(), other.isSystemDisk());
    }

    public final String toString() {
        return ToString.builder((String)"DiskInfo").add("Name", (Object)this.name()).add("Path", (Object)this.path()).add("SizeInGb", (Object)this.sizeInGb()).add("IsSystemDisk", (Object)this.isSystemDisk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "sizeInGb": {
                return Optional.ofNullable(clazz.cast(this.sizeInGb()));
            }
            case "isSystemDisk": {
                return Optional.ofNullable(clazz.cast(this.isSystemDisk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("path", PATH_FIELD);
        map.put("sizeInGb", SIZE_IN_GB_FIELD);
        map.put("isSystemDisk", IS_SYSTEM_DISK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DiskInfo, T> g) {
        return obj -> g.apply((DiskInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String path;
        private Integer sizeInGb;
        private Boolean isSystemDisk;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskInfo model) {
            this.name(model.name);
            this.path(model.path);
            this.sizeInGb(model.sizeInGb);
            this.isSystemDisk(model.isSystemDisk);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Integer getSizeInGb() {
            return this.sizeInGb;
        }

        public final void setSizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
        }

        @Override
        public final Builder sizeInGb(Integer sizeInGb) {
            this.sizeInGb = sizeInGb;
            return this;
        }

        public final Boolean getIsSystemDisk() {
            return this.isSystemDisk;
        }

        public final void setIsSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
        }

        @Override
        public final Builder isSystemDisk(Boolean isSystemDisk) {
            this.isSystemDisk = isSystemDisk;
            return this;
        }

        public DiskInfo build() {
            return new DiskInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskInfo> {
        public Builder name(String var1);

        public Builder path(String var1);

        public Builder sizeInGb(Integer var1);

        public Builder isSystemDisk(Boolean var1);
    }
}

