/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshot;
import software.amazon.awssdk.services.lightsail.model.RelationalDatabaseSnapshotListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRelationalDatabaseSnapshotsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, GetRelationalDatabaseSnapshotsResponse> {
    private static final SdkField<List<RelationalDatabaseSnapshot>> RELATIONAL_DATABASE_SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalDatabaseSnapshots").getter(GetRelationalDatabaseSnapshotsResponse.getter(GetRelationalDatabaseSnapshotsResponse::relationalDatabaseSnapshots)).setter(GetRelationalDatabaseSnapshotsResponse.setter(Builder::relationalDatabaseSnapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabaseSnapshots").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalDatabaseSnapshot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextPageToken").getter(GetRelationalDatabaseSnapshotsResponse.getter(GetRelationalDatabaseSnapshotsResponse::nextPageToken)).setter(GetRelationalDatabaseSnapshotsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASE_SNAPSHOTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRelationalDatabaseSnapshotsResponse.memberNameToFieldInitializer();
    private final List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots;
    private final String nextPageToken;

    private GetRelationalDatabaseSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabaseSnapshots = builder.relationalDatabaseSnapshots;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasRelationalDatabaseSnapshots() {
        return this.relationalDatabaseSnapshots != null && !(this.relationalDatabaseSnapshots instanceof SdkAutoConstructList);
    }

    public final List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots() {
        return this.relationalDatabaseSnapshots;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalDatabaseSnapshots() ? this.relationalDatabaseSnapshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabaseSnapshotsResponse)) {
            return false;
        }
        GetRelationalDatabaseSnapshotsResponse other = (GetRelationalDatabaseSnapshotsResponse)((Object)obj);
        return this.hasRelationalDatabaseSnapshots() == other.hasRelationalDatabaseSnapshots() && Objects.equals(this.relationalDatabaseSnapshots(), other.relationalDatabaseSnapshots()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRelationalDatabaseSnapshotsResponse").add("RelationalDatabaseSnapshots", this.hasRelationalDatabaseSnapshots() ? this.relationalDatabaseSnapshots() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relationalDatabaseSnapshots": {
                return Optional.ofNullable(clazz.cast(this.relationalDatabaseSnapshots()));
            }
            case "nextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationalDatabaseSnapshots", RELATIONAL_DATABASE_SNAPSHOTS_FIELD);
        map.put("nextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabaseSnapshotsResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabaseSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private List<RelationalDatabaseSnapshot> relationalDatabaseSnapshots = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabaseSnapshotsResponse model) {
            super(model);
            this.relationalDatabaseSnapshots(model.relationalDatabaseSnapshots);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<RelationalDatabaseSnapshot.Builder> getRelationalDatabaseSnapshots() {
            List<RelationalDatabaseSnapshot.Builder> result = RelationalDatabaseSnapshotListCopier.copyToBuilder(this.relationalDatabaseSnapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalDatabaseSnapshots(Collection<RelationalDatabaseSnapshot.BuilderImpl> relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots = RelationalDatabaseSnapshotListCopier.copyFromBuilder(relationalDatabaseSnapshots);
        }

        @Override
        public final Builder relationalDatabaseSnapshots(Collection<RelationalDatabaseSnapshot> relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots = RelationalDatabaseSnapshotListCopier.copy(relationalDatabaseSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseSnapshots(RelationalDatabaseSnapshot ... relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots(Arrays.asList(relationalDatabaseSnapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabaseSnapshots(Consumer<RelationalDatabaseSnapshot.Builder> ... relationalDatabaseSnapshots) {
            this.relationalDatabaseSnapshots(Stream.of(relationalDatabaseSnapshots).map(c -> (RelationalDatabaseSnapshot)((RelationalDatabaseSnapshot.Builder)RelationalDatabaseSnapshot.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetRelationalDatabaseSnapshotsResponse build() {
            return new GetRelationalDatabaseSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRelationalDatabaseSnapshotsResponse> {
        public Builder relationalDatabaseSnapshots(Collection<RelationalDatabaseSnapshot> var1);

        public Builder relationalDatabaseSnapshots(RelationalDatabaseSnapshot ... var1);

        public Builder relationalDatabaseSnapshots(Consumer<RelationalDatabaseSnapshot.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

