/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LightsailResponse;
import software.amazon.awssdk.services.lightsail.model.Session;
import software.amazon.awssdk.services.lightsail.model.SessionsCopier;
import software.amazon.awssdk.services.lightsail.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGuiSessionAccessDetailsResponse
extends LightsailResponse
implements ToCopyableBuilder<Builder, CreateGuiSessionAccessDetailsResponse> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceName").getter(CreateGuiSessionAccessDetailsResponse.getter(CreateGuiSessionAccessDetailsResponse::resourceName)).setter(CreateGuiSessionAccessDetailsResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateGuiSessionAccessDetailsResponse.getter(CreateGuiSessionAccessDetailsResponse::statusAsString)).setter(CreateGuiSessionAccessDetailsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> PERCENTAGE_COMPLETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("percentageComplete").getter(CreateGuiSessionAccessDetailsResponse.getter(CreateGuiSessionAccessDetailsResponse::percentageComplete)).setter(CreateGuiSessionAccessDetailsResponse.setter(Builder::percentageComplete)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentageComplete").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(CreateGuiSessionAccessDetailsResponse.getter(CreateGuiSessionAccessDetailsResponse::failureReason)).setter(CreateGuiSessionAccessDetailsResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<List<Session>> SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessions").getter(CreateGuiSessionAccessDetailsResponse.getter(CreateGuiSessionAccessDetailsResponse::sessions)).setter(CreateGuiSessionAccessDetailsResponse.setter(Builder::sessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Session::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, STATUS_FIELD, PERCENTAGE_COMPLETE_FIELD, FAILURE_REASON_FIELD, SESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGuiSessionAccessDetailsResponse.memberNameToFieldInitializer();
    private final String resourceName;
    private final String status;
    private final Integer percentageComplete;
    private final String failureReason;
    private final List<Session> sessions;

    private CreateGuiSessionAccessDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceName = builder.resourceName;
        this.status = builder.status;
        this.percentageComplete = builder.percentageComplete;
        this.failureReason = builder.failureReason;
        this.sessions = builder.sessions;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer percentageComplete() {
        return this.percentageComplete;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasSessions() {
        return this.sessions != null && !(this.sessions instanceof SdkAutoConstructList);
    }

    public final List<Session> sessions() {
        return this.sessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessions() ? this.sessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGuiSessionAccessDetailsResponse)) {
            return false;
        }
        CreateGuiSessionAccessDetailsResponse other = (CreateGuiSessionAccessDetailsResponse)((Object)obj);
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.percentageComplete(), other.percentageComplete()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasSessions() == other.hasSessions() && Objects.equals(this.sessions(), other.sessions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGuiSessionAccessDetailsResponse").add("ResourceName", (Object)this.resourceName()).add("Status", (Object)this.statusAsString()).add("PercentageComplete", (Object)this.percentageComplete()).add("FailureReason", (Object)this.failureReason()).add("Sessions", this.hasSessions() ? this.sessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "percentageComplete": {
                return Optional.ofNullable(clazz.cast(this.percentageComplete()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "sessions": {
                return Optional.ofNullable(clazz.cast(this.sessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceName", RESOURCE_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("percentageComplete", PERCENTAGE_COMPLETE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("sessions", SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGuiSessionAccessDetailsResponse, T> g) {
        return obj -> g.apply((CreateGuiSessionAccessDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailResponse.BuilderImpl
    implements Builder {
        private String resourceName;
        private String status;
        private Integer percentageComplete;
        private String failureReason;
        private List<Session> sessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGuiSessionAccessDetailsResponse model) {
            super(model);
            this.resourceName(model.resourceName);
            this.status(model.status);
            this.percentageComplete(model.percentageComplete);
            this.failureReason(model.failureReason);
            this.sessions(model.sessions);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPercentageComplete() {
            return this.percentageComplete;
        }

        public final void setPercentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
        }

        @Override
        public final Builder percentageComplete(Integer percentageComplete) {
            this.percentageComplete = percentageComplete;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<Session.Builder> getSessions() {
            List<Session.Builder> result = SessionsCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<Session.BuilderImpl> sessions) {
            this.sessions = SessionsCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<Session> sessions) {
            this.sessions = SessionsCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Session ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<Session.Builder> ... sessions) {
            this.sessions(Stream.of(sessions).map(c -> (Session)((Session.Builder)Session.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateGuiSessionAccessDetailsResponse build() {
            return new CreateGuiSessionAccessDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LightsailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGuiSessionAccessDetailsResponse> {
        public Builder resourceName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder percentageComplete(Integer var1);

        public Builder failureReason(String var1);

        public Builder sessions(Collection<Session> var1);

        public Builder sessions(Session ... var1);

        public Builder sessions(Consumer<Session.Builder> ... var1);
    }
}

