/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceBucketAccess {
    ALLOW("allow"),
    DENY("deny"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceBucketAccess> VALUE_MAP;
    private final String value;

    private ResourceBucketAccess(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceBucketAccess fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceBucketAccess> knownValues() {
        EnumSet<ResourceBucketAccess> knownValues = EnumSet.allOf(ResourceBucketAccess.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceBucketAccess.class, ResourceBucketAccess::toString);
    }
}

