/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BucketBundle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BucketBundle> {
    private static final SdkField<String> BUNDLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bundleId").getter(BucketBundle.getter(BucketBundle::bundleId)).setter(BucketBundle.setter(Builder::bundleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bundleId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(BucketBundle.getter(BucketBundle::name)).setter(BucketBundle.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Float> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("price").getter(BucketBundle.getter(BucketBundle::price)).setter(BucketBundle.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()}).build();
    private static final SdkField<Integer> STORAGE_PER_MONTH_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storagePerMonthInGb").getter(BucketBundle.getter(BucketBundle::storagePerMonthInGb)).setter(BucketBundle.setter(Builder::storagePerMonthInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storagePerMonthInGb").build()}).build();
    private static final SdkField<Integer> TRANSFER_PER_MONTH_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("transferPerMonthInGb").getter(BucketBundle.getter(BucketBundle::transferPerMonthInGb)).setter(BucketBundle.setter(Builder::transferPerMonthInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferPerMonthInGb").build()}).build();
    private static final SdkField<Boolean> IS_ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isActive").getter(BucketBundle.getter(BucketBundle::isActive)).setter(BucketBundle.setter(Builder::isActive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isActive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUNDLE_ID_FIELD, NAME_FIELD, PRICE_FIELD, STORAGE_PER_MONTH_IN_GB_FIELD, TRANSFER_PER_MONTH_IN_GB_FIELD, IS_ACTIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BucketBundle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bundleId;
    private final String name;
    private final Float price;
    private final Integer storagePerMonthInGb;
    private final Integer transferPerMonthInGb;
    private final Boolean isActive;

    private BucketBundle(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.name = builder.name;
        this.price = builder.price;
        this.storagePerMonthInGb = builder.storagePerMonthInGb;
        this.transferPerMonthInGb = builder.transferPerMonthInGb;
        this.isActive = builder.isActive;
    }

    public final String bundleId() {
        return this.bundleId;
    }

    public final String name() {
        return this.name;
    }

    public final Float price() {
        return this.price;
    }

    public final Integer storagePerMonthInGb() {
        return this.storagePerMonthInGb;
    }

    public final Integer transferPerMonthInGb() {
        return this.transferPerMonthInGb;
    }

    public final Boolean isActive() {
        return this.isActive;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.storagePerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferPerMonthInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.isActive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BucketBundle)) {
            return false;
        }
        BucketBundle other = (BucketBundle)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.price(), other.price()) && Objects.equals(this.storagePerMonthInGb(), other.storagePerMonthInGb()) && Objects.equals(this.transferPerMonthInGb(), other.transferPerMonthInGb()) && Objects.equals(this.isActive(), other.isActive());
    }

    public final String toString() {
        return ToString.builder((String)"BucketBundle").add("BundleId", (Object)this.bundleId()).add("Name", (Object)this.name()).add("Price", (Object)this.price()).add("StoragePerMonthInGb", (Object)this.storagePerMonthInGb()).add("TransferPerMonthInGb", (Object)this.transferPerMonthInGb()).add("IsActive", (Object)this.isActive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bundleId": {
                return Optional.ofNullable(clazz.cast(this.bundleId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "storagePerMonthInGb": {
                return Optional.ofNullable(clazz.cast(this.storagePerMonthInGb()));
            }
            case "transferPerMonthInGb": {
                return Optional.ofNullable(clazz.cast(this.transferPerMonthInGb()));
            }
            case "isActive": {
                return Optional.ofNullable(clazz.cast(this.isActive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bundleId", BUNDLE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("price", PRICE_FIELD);
        map.put("storagePerMonthInGb", STORAGE_PER_MONTH_IN_GB_FIELD);
        map.put("transferPerMonthInGb", TRANSFER_PER_MONTH_IN_GB_FIELD);
        map.put("isActive", IS_ACTIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BucketBundle, T> g) {
        return obj -> g.apply((BucketBundle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private String name;
        private Float price;
        private Integer storagePerMonthInGb;
        private Integer transferPerMonthInGb;
        private Boolean isActive;

        private BuilderImpl() {
        }

        private BuilderImpl(BucketBundle model) {
            this.bundleId(model.bundleId);
            this.name(model.name);
            this.price(model.price);
            this.storagePerMonthInGb(model.storagePerMonthInGb);
            this.transferPerMonthInGb(model.transferPerMonthInGb);
            this.isActive(model.isActive);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Float getPrice() {
            return this.price;
        }

        public final void setPrice(Float price) {
            this.price = price;
        }

        @Override
        public final Builder price(Float price) {
            this.price = price;
            return this;
        }

        public final Integer getStoragePerMonthInGb() {
            return this.storagePerMonthInGb;
        }

        public final void setStoragePerMonthInGb(Integer storagePerMonthInGb) {
            this.storagePerMonthInGb = storagePerMonthInGb;
        }

        @Override
        public final Builder storagePerMonthInGb(Integer storagePerMonthInGb) {
            this.storagePerMonthInGb = storagePerMonthInGb;
            return this;
        }

        public final Integer getTransferPerMonthInGb() {
            return this.transferPerMonthInGb;
        }

        public final void setTransferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
        }

        @Override
        public final Builder transferPerMonthInGb(Integer transferPerMonthInGb) {
            this.transferPerMonthInGb = transferPerMonthInGb;
            return this;
        }

        public final Boolean getIsActive() {
            return this.isActive;
        }

        public final void setIsActive(Boolean isActive) {
            this.isActive = isActive;
        }

        @Override
        public final Builder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public BucketBundle build() {
            return new BucketBundle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BucketBundle> {
        public Builder bundleId(String var1);

        public Builder name(String var1);

        public Builder price(Float var1);

        public Builder storagePerMonthInGb(Integer var1);

        public Builder transferPerMonthInGb(Integer var1);

        public Builder isActive(Boolean var1);
    }
}

