/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsResponse;

public class ListLicenseServerEndpointsIterable
implements SdkIterable<ListLicenseServerEndpointsResponse> {
    private final LicenseManagerUserSubscriptionsClient client;
    private final ListLicenseServerEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLicenseServerEndpointsIterable(LicenseManagerUserSubscriptionsClient client, ListLicenseServerEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLicenseServerEndpointsResponseFetcher();
    }

    public Iterator<ListLicenseServerEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LicenseServerEndpoint> licenseServerEndpoints() {
        Function<ListLicenseServerEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.licenseServerEndpoints() != null) {
                return response.licenseServerEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLicenseServerEndpointsResponseFetcher
    implements SyncPageFetcher<ListLicenseServerEndpointsResponse> {
        private ListLicenseServerEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListLicenseServerEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLicenseServerEndpointsResponse nextPage(ListLicenseServerEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListLicenseServerEndpointsIterable.this.client.listLicenseServerEndpoints(ListLicenseServerEndpointsIterable.this.firstRequest);
            }
            return ListLicenseServerEndpointsIterable.this.client.listLicenseServerEndpoints((ListLicenseServerEndpointsRequest)((Object)ListLicenseServerEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

