/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Filter;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.FilterListCopier;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserAssociationsRequest
extends LicenseManagerUserSubscriptionsRequest
implements ToCopyableBuilder<Builder, ListUserAssociationsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListUserAssociationsRequest.getter(ListUserAssociationsRequest::instanceId)).setter(ListUserAssociationsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProvider").getter(ListUserAssociationsRequest.getter(ListUserAssociationsRequest::identityProvider)).setter(ListUserAssociationsRequest.setter(Builder::identityProvider)).constructor(IdentityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListUserAssociationsRequest.getter(ListUserAssociationsRequest::maxResults)).setter(ListUserAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListUserAssociationsRequest.getter(ListUserAssociationsRequest::filters)).setter(ListUserAssociationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListUserAssociationsRequest.getter(ListUserAssociationsRequest::nextToken)).setter(ListUserAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, IDENTITY_PROVIDER_FIELD, MAX_RESULTS_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUserAssociationsRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final IdentityProvider identityProvider;
    private final Integer maxResults;
    private final List<Filter> filters;
    private final String nextToken;

    private ListUserAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.identityProvider = builder.identityProvider;
        this.maxResults = builder.maxResults;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserAssociationsRequest)) {
            return false;
        }
        ListUserAssociationsRequest other = (ListUserAssociationsRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.identityProvider(), other.identityProvider()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserAssociationsRequest").add("InstanceId", (Object)this.instanceId()).add("IdentityProvider", (Object)this.identityProvider()).add("MaxResults", (Object)this.maxResults()).add("Filters", this.hasFilters() ? this.filters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProvider()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUserAssociationsRequest, T> g) {
        return obj -> g.apply((ListUserAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private IdentityProvider identityProvider;
        private Integer maxResults;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserAssociationsRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.identityProvider(model.identityProvider);
            this.maxResults(model.maxResults);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return this.identityProvider != null ? this.identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListUserAssociationsRequest build() {
            return new ListUserAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerUserSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserAssociationsRequest> {
        public Builder instanceId(String var1);

        public Builder identityProvider(IdentityProvider var1);

        default public Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return this.identityProvider((IdentityProvider)((IdentityProvider.Builder)IdentityProvider.builder().applyMutation(identityProvider)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

