/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.LicenseManagerUserSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseServerEndpoint;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.ListLicenseServerEndpointsResponse;

public class ListLicenseServerEndpointsPublisher
implements SdkPublisher<ListLicenseServerEndpointsResponse> {
    private final LicenseManagerUserSubscriptionsAsyncClient client;
    private final ListLicenseServerEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLicenseServerEndpointsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListLicenseServerEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLicenseServerEndpointsPublisher(LicenseManagerUserSubscriptionsAsyncClient client, ListLicenseServerEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLicenseServerEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLicenseServerEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LicenseServerEndpoint> licenseServerEndpoints() {
        Function<ListLicenseServerEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.licenseServerEndpoints() != null) {
                return response.licenseServerEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLicenseServerEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLicenseServerEndpointsResponseFetcher
    implements AsyncPageFetcher<ListLicenseServerEndpointsResponse> {
        private ListLicenseServerEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListLicenseServerEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLicenseServerEndpointsResponse> nextPage(ListLicenseServerEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListLicenseServerEndpointsPublisher.this.client.listLicenseServerEndpoints(ListLicenseServerEndpointsPublisher.this.firstRequest);
            }
            return ListLicenseServerEndpointsPublisher.this.client.listLicenseServerEndpoints((ListLicenseServerEndpointsRequest)((Object)ListLicenseServerEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

