/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerusersubscriptions.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.IdentityProvider;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.LicenseManagerUserSubscriptionsRequest;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.Settings;
import software.amazon.awssdk.services.licensemanagerusersubscriptions.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterIdentityProviderRequest
extends LicenseManagerUserSubscriptionsRequest
implements ToCopyableBuilder<Builder, RegisterIdentityProviderRequest> {
    private static final SdkField<IdentityProvider> IDENTITY_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProvider").getter(RegisterIdentityProviderRequest.getter(RegisterIdentityProviderRequest::identityProvider)).setter(RegisterIdentityProviderRequest.setter(Builder::identityProvider)).constructor(IdentityProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProvider").build()}).build();
    private static final SdkField<String> PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Product").getter(RegisterIdentityProviderRequest.getter(RegisterIdentityProviderRequest::product)).setter(RegisterIdentityProviderRequest.setter(Builder::product)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Product").build()}).build();
    private static final SdkField<Settings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(RegisterIdentityProviderRequest.getter(RegisterIdentityProviderRequest::settings)).setter(RegisterIdentityProviderRequest.setter(Builder::settings)).constructor(Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RegisterIdentityProviderRequest.getter(RegisterIdentityProviderRequest::tags)).setter(RegisterIdentityProviderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_FIELD, PRODUCT_FIELD, SETTINGS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterIdentityProviderRequest.memberNameToFieldInitializer();
    private final IdentityProvider identityProvider;
    private final String product;
    private final Settings settings;
    private final Map<String, String> tags;

    private RegisterIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.identityProvider = builder.identityProvider;
        this.product = builder.product;
        this.settings = builder.settings;
        this.tags = builder.tags;
    }

    public final IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    public final String product() {
        return this.product;
    }

    public final Settings settings() {
        return this.settings;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(this.product());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterIdentityProviderRequest)) {
            return false;
        }
        RegisterIdentityProviderRequest other = (RegisterIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.identityProvider(), other.identityProvider()) && Objects.equals(this.product(), other.product()) && Objects.equals(this.settings(), other.settings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterIdentityProviderRequest").add("IdentityProvider", (Object)this.identityProvider()).add("Product", (Object)this.product()).add("Settings", (Object)this.settings()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityProvider": {
                return Optional.ofNullable(clazz.cast(this.identityProvider()));
            }
            case "Product": {
                return Optional.ofNullable(clazz.cast(this.product()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityProvider", IDENTITY_PROVIDER_FIELD);
        map.put("Product", PRODUCT_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterIdentityProviderRequest, T> g) {
        return obj -> g.apply((RegisterIdentityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerUserSubscriptionsRequest.BuilderImpl
    implements Builder {
        private IdentityProvider identityProvider;
        private String product;
        private Settings settings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterIdentityProviderRequest model) {
            super(model);
            this.identityProvider(model.identityProvider);
            this.product(model.product);
            this.settings(model.settings);
            this.tags(model.tags);
        }

        public final IdentityProvider.Builder getIdentityProvider() {
            return this.identityProvider != null ? this.identityProvider.toBuilder() : null;
        }

        public final void setIdentityProvider(IdentityProvider.BuilderImpl identityProvider) {
            this.identityProvider = identityProvider != null ? identityProvider.build() : null;
        }

        @Override
        public final Builder identityProvider(IdentityProvider identityProvider) {
            this.identityProvider = identityProvider;
            return this;
        }

        public final String getProduct() {
            return this.product;
        }

        public final void setProduct(String product) {
            this.product = product;
        }

        @Override
        public final Builder product(String product) {
            this.product = product;
            return this;
        }

        public final Settings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(Settings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterIdentityProviderRequest build() {
            return new RegisterIdentityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerUserSubscriptionsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterIdentityProviderRequest> {
        public Builder identityProvider(IdentityProvider var1);

        default public Builder identityProvider(Consumer<IdentityProvider.Builder> identityProvider) {
            return this.identityProvider((IdentityProvider)((IdentityProvider.Builder)IdentityProvider.builder().applyMutation(identityProvider)).build());
        }

        public Builder product(String var1);

        public Builder settings(Settings var1);

        default public Builder settings(Consumer<Settings.Builder> settings) {
            return this.settings((Settings)((Settings.Builder)Settings.builder().applyMutation(settings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

