/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider;

public class ListRegisteredSubscriptionProvidersIterable
implements SdkIterable<ListRegisteredSubscriptionProvidersResponse> {
    private final LicenseManagerLinuxSubscriptionsClient client;
    private final ListRegisteredSubscriptionProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRegisteredSubscriptionProvidersIterable(LicenseManagerLinuxSubscriptionsClient client, ListRegisteredSubscriptionProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRegisteredSubscriptionProvidersResponseFetcher();
    }

    public Iterator<ListRegisteredSubscriptionProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RegisteredSubscriptionProvider> registeredSubscriptionProviders() {
        Function<ListRegisteredSubscriptionProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.registeredSubscriptionProviders() != null) {
                return response.registeredSubscriptionProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRegisteredSubscriptionProvidersResponseFetcher
    implements SyncPageFetcher<ListRegisteredSubscriptionProvidersResponse> {
        private ListRegisteredSubscriptionProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListRegisteredSubscriptionProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRegisteredSubscriptionProvidersResponse nextPage(ListRegisteredSubscriptionProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListRegisteredSubscriptionProvidersIterable.this.client.listRegisteredSubscriptionProviders(ListRegisteredSubscriptionProvidersIterable.this.firstRequest);
            }
            return ListRegisteredSubscriptionProvidersIterable.this.client.listRegisteredSubscriptionProviders((ListRegisteredSubscriptionProvidersRequest)((Object)ListRegisteredSubscriptionProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

