/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.LicenseManagerLinuxSubscriptionsAsyncClient;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.internal.UserAgentUtils;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersRequest;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.ListRegisteredSubscriptionProvidersResponse;
import software.amazon.awssdk.services.licensemanagerlinuxsubscriptions.model.RegisteredSubscriptionProvider;

public class ListRegisteredSubscriptionProvidersPublisher
implements SdkPublisher<ListRegisteredSubscriptionProvidersResponse> {
    private final LicenseManagerLinuxSubscriptionsAsyncClient client;
    private final ListRegisteredSubscriptionProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRegisteredSubscriptionProvidersPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListRegisteredSubscriptionProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRegisteredSubscriptionProvidersPublisher(LicenseManagerLinuxSubscriptionsAsyncClient client, ListRegisteredSubscriptionProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRegisteredSubscriptionProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRegisteredSubscriptionProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RegisteredSubscriptionProvider> registeredSubscriptionProviders() {
        Function<ListRegisteredSubscriptionProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.registeredSubscriptionProviders() != null) {
                return response.registeredSubscriptionProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRegisteredSubscriptionProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRegisteredSubscriptionProvidersResponseFetcher
    implements AsyncPageFetcher<ListRegisteredSubscriptionProvidersResponse> {
        private ListRegisteredSubscriptionProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListRegisteredSubscriptionProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRegisteredSubscriptionProvidersResponse> nextPage(ListRegisteredSubscriptionProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListRegisteredSubscriptionProvidersPublisher.this.client.listRegisteredSubscriptionProviders(ListRegisteredSubscriptionProvidersPublisher.this.firstRequest);
            }
            return ListRegisteredSubscriptionProvidersPublisher.this.client.listRegisteredSubscriptionProviders((ListRegisteredSubscriptionProvidersRequest)((Object)ListRegisteredSubscriptionProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

