/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroup;
import software.amazon.awssdk.services.licensemanager.model.LicenseAssetGroupListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLicenseAssetGroupsResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListLicenseAssetGroupsResponse> {
    private static final SdkField<List<LicenseAssetGroup>> LICENSE_ASSET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseAssetGroups").getter(ListLicenseAssetGroupsResponse.getter(ListLicenseAssetGroupsResponse::licenseAssetGroups)).setter(ListLicenseAssetGroupsResponse.setter(Builder::licenseAssetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LicenseAssetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLicenseAssetGroupsResponse.getter(ListLicenseAssetGroupsResponse::nextToken)).setter(ListLicenseAssetGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ASSET_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListLicenseAssetGroupsResponse.memberNameToFieldInitializer();
    private final List<LicenseAssetGroup> licenseAssetGroups;
    private final String nextToken;

    private ListLicenseAssetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.licenseAssetGroups = builder.licenseAssetGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenseAssetGroups() {
        return this.licenseAssetGroups != null && !(this.licenseAssetGroups instanceof SdkAutoConstructList);
    }

    public final List<LicenseAssetGroup> licenseAssetGroups() {
        return this.licenseAssetGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseAssetGroups() ? this.licenseAssetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLicenseAssetGroupsResponse)) {
            return false;
        }
        ListLicenseAssetGroupsResponse other = (ListLicenseAssetGroupsResponse)((Object)obj);
        return this.hasLicenseAssetGroups() == other.hasLicenseAssetGroups() && Objects.equals(this.licenseAssetGroups(), other.licenseAssetGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLicenseAssetGroupsResponse").add("LicenseAssetGroups", this.hasLicenseAssetGroups() ? this.licenseAssetGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseAssetGroups": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseAssetGroups", LICENSE_ASSET_GROUPS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLicenseAssetGroupsResponse, T> g) {
        return obj -> g.apply((ListLicenseAssetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<LicenseAssetGroup> licenseAssetGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLicenseAssetGroupsResponse model) {
            super(model);
            this.licenseAssetGroups(model.licenseAssetGroups);
            this.nextToken(model.nextToken);
        }

        public final List<LicenseAssetGroup.Builder> getLicenseAssetGroups() {
            List<LicenseAssetGroup.Builder> result = LicenseAssetGroupListCopier.copyToBuilder(this.licenseAssetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseAssetGroups(Collection<LicenseAssetGroup.BuilderImpl> licenseAssetGroups) {
            this.licenseAssetGroups = LicenseAssetGroupListCopier.copyFromBuilder(licenseAssetGroups);
        }

        @Override
        public final Builder licenseAssetGroups(Collection<LicenseAssetGroup> licenseAssetGroups) {
            this.licenseAssetGroups = LicenseAssetGroupListCopier.copy(licenseAssetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroups(LicenseAssetGroup ... licenseAssetGroups) {
            this.licenseAssetGroups(Arrays.asList(licenseAssetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseAssetGroups(Consumer<LicenseAssetGroup.Builder> ... licenseAssetGroups) {
            this.licenseAssetGroups(Stream.of(licenseAssetGroups).map(c -> (LicenseAssetGroup)((LicenseAssetGroup.Builder)LicenseAssetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLicenseAssetGroupsResponse build() {
            return new ListLicenseAssetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLicenseAssetGroupsResponse> {
        public Builder licenseAssetGroups(Collection<LicenseAssetGroup> var1);

        public Builder licenseAssetGroups(LicenseAssetGroup ... var1);

        public Builder licenseAssetGroups(Consumer<LicenseAssetGroup.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

