/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.MatchingRuleStatement;
import software.amazon.awssdk.services.licensemanager.model.MatchingRuleStatementListCopier;
import software.amazon.awssdk.services.licensemanager.model.ScriptRuleStatement;
import software.amazon.awssdk.services.licensemanager.model.ScriptRuleStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrRuleStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrRuleStatement> {
    private static final SdkField<List<MatchingRuleStatement>> MATCHING_RULE_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchingRuleStatements").getter(OrRuleStatement.getter(OrRuleStatement::matchingRuleStatements)).setter(OrRuleStatement.setter(Builder::matchingRuleStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingRuleStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchingRuleStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ScriptRuleStatement>> SCRIPT_RULE_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScriptRuleStatements").getter(OrRuleStatement.getter(OrRuleStatement::scriptRuleStatements)).setter(OrRuleStatement.setter(Builder::scriptRuleStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptRuleStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScriptRuleStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHING_RULE_STATEMENTS_FIELD, SCRIPT_RULE_STATEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrRuleStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MatchingRuleStatement> matchingRuleStatements;
    private final List<ScriptRuleStatement> scriptRuleStatements;

    private OrRuleStatement(BuilderImpl builder) {
        this.matchingRuleStatements = builder.matchingRuleStatements;
        this.scriptRuleStatements = builder.scriptRuleStatements;
    }

    public final boolean hasMatchingRuleStatements() {
        return this.matchingRuleStatements != null && !(this.matchingRuleStatements instanceof SdkAutoConstructList);
    }

    public final List<MatchingRuleStatement> matchingRuleStatements() {
        return this.matchingRuleStatements;
    }

    public final boolean hasScriptRuleStatements() {
        return this.scriptRuleStatements != null && !(this.scriptRuleStatements instanceof SdkAutoConstructList);
    }

    public final List<ScriptRuleStatement> scriptRuleStatements() {
        return this.scriptRuleStatements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchingRuleStatements() ? this.matchingRuleStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScriptRuleStatements() ? this.scriptRuleStatements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrRuleStatement)) {
            return false;
        }
        OrRuleStatement other = (OrRuleStatement)obj;
        return this.hasMatchingRuleStatements() == other.hasMatchingRuleStatements() && Objects.equals(this.matchingRuleStatements(), other.matchingRuleStatements()) && this.hasScriptRuleStatements() == other.hasScriptRuleStatements() && Objects.equals(this.scriptRuleStatements(), other.scriptRuleStatements());
    }

    public final String toString() {
        return ToString.builder((String)"OrRuleStatement").add("MatchingRuleStatements", this.hasMatchingRuleStatements() ? this.matchingRuleStatements() : null).add("ScriptRuleStatements", this.hasScriptRuleStatements() ? this.scriptRuleStatements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchingRuleStatements": {
                return Optional.ofNullable(clazz.cast(this.matchingRuleStatements()));
            }
            case "ScriptRuleStatements": {
                return Optional.ofNullable(clazz.cast(this.scriptRuleStatements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchingRuleStatements", MATCHING_RULE_STATEMENTS_FIELD);
        map.put("ScriptRuleStatements", SCRIPT_RULE_STATEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrRuleStatement, T> g) {
        return obj -> g.apply((OrRuleStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MatchingRuleStatement> matchingRuleStatements = DefaultSdkAutoConstructList.getInstance();
        private List<ScriptRuleStatement> scriptRuleStatements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OrRuleStatement model) {
            this.matchingRuleStatements(model.matchingRuleStatements);
            this.scriptRuleStatements(model.scriptRuleStatements);
        }

        public final List<MatchingRuleStatement.Builder> getMatchingRuleStatements() {
            List<MatchingRuleStatement.Builder> result = MatchingRuleStatementListCopier.copyToBuilder(this.matchingRuleStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchingRuleStatements(Collection<MatchingRuleStatement.BuilderImpl> matchingRuleStatements) {
            this.matchingRuleStatements = MatchingRuleStatementListCopier.copyFromBuilder(matchingRuleStatements);
        }

        @Override
        public final Builder matchingRuleStatements(Collection<MatchingRuleStatement> matchingRuleStatements) {
            this.matchingRuleStatements = MatchingRuleStatementListCopier.copy(matchingRuleStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRuleStatements(MatchingRuleStatement ... matchingRuleStatements) {
            this.matchingRuleStatements(Arrays.asList(matchingRuleStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRuleStatements(Consumer<MatchingRuleStatement.Builder> ... matchingRuleStatements) {
            this.matchingRuleStatements(Stream.of(matchingRuleStatements).map(c -> (MatchingRuleStatement)((MatchingRuleStatement.Builder)MatchingRuleStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ScriptRuleStatement.Builder> getScriptRuleStatements() {
            List<ScriptRuleStatement.Builder> result = ScriptRuleStatementListCopier.copyToBuilder(this.scriptRuleStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScriptRuleStatements(Collection<ScriptRuleStatement.BuilderImpl> scriptRuleStatements) {
            this.scriptRuleStatements = ScriptRuleStatementListCopier.copyFromBuilder(scriptRuleStatements);
        }

        @Override
        public final Builder scriptRuleStatements(Collection<ScriptRuleStatement> scriptRuleStatements) {
            this.scriptRuleStatements = ScriptRuleStatementListCopier.copy(scriptRuleStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptRuleStatements(ScriptRuleStatement ... scriptRuleStatements) {
            this.scriptRuleStatements(Arrays.asList(scriptRuleStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scriptRuleStatements(Consumer<ScriptRuleStatement.Builder> ... scriptRuleStatements) {
            this.scriptRuleStatements(Stream.of(scriptRuleStatements).map(c -> (ScriptRuleStatement)((ScriptRuleStatement.Builder)ScriptRuleStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OrRuleStatement build() {
            return new OrRuleStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrRuleStatement> {
        public Builder matchingRuleStatements(Collection<MatchingRuleStatement> var1);

        public Builder matchingRuleStatements(MatchingRuleStatement ... var1);

        public Builder matchingRuleStatements(Consumer<MatchingRuleStatement.Builder> ... var1);

        public Builder scriptRuleStatements(Collection<ScriptRuleStatement> var1);

        public Builder scriptRuleStatements(ScriptRuleStatement ... var1);

        public Builder scriptRuleStatements(Consumer<ScriptRuleStatement.Builder> ... var1);
    }
}

