/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLicenseAssetGroupRequest
extends LicenseManagerRequest
implements ToCopyableBuilder<Builder, DeleteLicenseAssetGroupRequest> {
    private static final SdkField<String> LICENSE_ASSET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseAssetGroupArn").getter(DeleteLicenseAssetGroupRequest.getter(DeleteLicenseAssetGroupRequest::licenseAssetGroupArn)).setter(DeleteLicenseAssetGroupRequest.setter(Builder::licenseAssetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseAssetGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ASSET_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteLicenseAssetGroupRequest.memberNameToFieldInitializer();
    private final String licenseAssetGroupArn;

    private DeleteLicenseAssetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.licenseAssetGroupArn = builder.licenseAssetGroupArn;
    }

    public final String licenseAssetGroupArn() {
        return this.licenseAssetGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseAssetGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLicenseAssetGroupRequest)) {
            return false;
        }
        DeleteLicenseAssetGroupRequest other = (DeleteLicenseAssetGroupRequest)((Object)obj);
        return Objects.equals(this.licenseAssetGroupArn(), other.licenseAssetGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLicenseAssetGroupRequest").add("LicenseAssetGroupArn", (Object)this.licenseAssetGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseAssetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.licenseAssetGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LicenseAssetGroupArn", LICENSE_ASSET_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteLicenseAssetGroupRequest, T> g) {
        return obj -> g.apply((DeleteLicenseAssetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerRequest.BuilderImpl
    implements Builder {
        private String licenseAssetGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLicenseAssetGroupRequest model) {
            super(model);
            this.licenseAssetGroupArn(model.licenseAssetGroupArn);
        }

        public final String getLicenseAssetGroupArn() {
            return this.licenseAssetGroupArn;
        }

        public final void setLicenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
        }

        @Override
        public final Builder licenseAssetGroupArn(String licenseAssetGroupArn) {
            this.licenseAssetGroupArn = licenseAssetGroupArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLicenseAssetGroupRequest build() {
            return new DeleteLicenseAssetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLicenseAssetGroupRequest> {
        public Builder licenseAssetGroupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

