/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.GrantedLicense;
import software.amazon.awssdk.services.licensemanager.model.GrantedLicenseListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReceivedLicensesForOrganizationResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, ListReceivedLicensesForOrganizationResponse> {
    private static final SdkField<List<GrantedLicense>> LICENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Licenses").getter(ListReceivedLicensesForOrganizationResponse.getter(ListReceivedLicensesForOrganizationResponse::licenses)).setter(ListReceivedLicensesForOrganizationResponse.setter(Builder::licenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Licenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GrantedLicense::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReceivedLicensesForOrganizationResponse.getter(ListReceivedLicensesForOrganizationResponse::nextToken)).setter(ListReceivedLicensesForOrganizationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReceivedLicensesForOrganizationResponse.memberNameToFieldInitializer();
    private final List<GrantedLicense> licenses;
    private final String nextToken;

    private ListReceivedLicensesForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.licenses = builder.licenses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLicenses() {
        return this.licenses != null && !(this.licenses instanceof SdkAutoConstructList);
    }

    public final List<GrantedLicense> licenses() {
        return this.licenses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenses() ? this.licenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceivedLicensesForOrganizationResponse)) {
            return false;
        }
        ListReceivedLicensesForOrganizationResponse other = (ListReceivedLicensesForOrganizationResponse)((Object)obj);
        return this.hasLicenses() == other.hasLicenses() && Objects.equals(this.licenses(), other.licenses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReceivedLicensesForOrganizationResponse").add("Licenses", this.hasLicenses() ? this.licenses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Licenses": {
                return Optional.ofNullable(clazz.cast(this.licenses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Licenses", LICENSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReceivedLicensesForOrganizationResponse, T> g) {
        return obj -> g.apply((ListReceivedLicensesForOrganizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private List<GrantedLicense> licenses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceivedLicensesForOrganizationResponse model) {
            super(model);
            this.licenses(model.licenses);
            this.nextToken(model.nextToken);
        }

        public final List<GrantedLicense.Builder> getLicenses() {
            List<GrantedLicense.Builder> result = GrantedLicenseListCopier.copyToBuilder(this.licenses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenses(Collection<GrantedLicense.BuilderImpl> licenses) {
            this.licenses = GrantedLicenseListCopier.copyFromBuilder(licenses);
        }

        @Override
        public final Builder licenses(Collection<GrantedLicense> licenses) {
            this.licenses = GrantedLicenseListCopier.copy(licenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(GrantedLicense ... licenses) {
            this.licenses(Arrays.asList(licenses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenses(Consumer<GrantedLicense.Builder> ... licenses) {
            this.licenses(Stream.of(licenses).map(c -> (GrantedLicense)((GrantedLicense.Builder)GrantedLicense.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReceivedLicensesForOrganizationResponse build() {
            return new ListReceivedLicensesForOrganizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReceivedLicensesForOrganizationResponse> {
        public Builder licenses(Collection<GrantedLicense> var1);

        public Builder licenses(GrantedLicense ... var1);

        public Builder licenses(Consumer<GrantedLicense.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

