/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ProductCodeListCopier;
import software.amazon.awssdk.services.licensemanager.model.ProductCodeListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LicenseConversionContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LicenseConversionContext> {
    private static final SdkField<String> USAGE_OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsageOperation").getter(LicenseConversionContext.getter(LicenseConversionContext::usageOperation)).setter(LicenseConversionContext.setter(Builder::usageOperation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageOperation").build()}).build();
    private static final SdkField<List<ProductCodeListItem>> PRODUCT_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductCodes").getter(LicenseConversionContext.getter(LicenseConversionContext::productCodes)).setter(LicenseConversionContext.setter(Builder::productCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductCodeListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_OPERATION_FIELD, PRODUCT_CODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LicenseConversionContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String usageOperation;
    private final List<ProductCodeListItem> productCodes;

    private LicenseConversionContext(BuilderImpl builder) {
        this.usageOperation = builder.usageOperation;
        this.productCodes = builder.productCodes;
    }

    public final String usageOperation() {
        return this.usageOperation;
    }

    public final boolean hasProductCodes() {
        return this.productCodes != null && !(this.productCodes instanceof SdkAutoConstructList);
    }

    public final List<ProductCodeListItem> productCodes() {
        return this.productCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOperation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductCodes() ? this.productCodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseConversionContext)) {
            return false;
        }
        LicenseConversionContext other = (LicenseConversionContext)obj;
        return Objects.equals(this.usageOperation(), other.usageOperation()) && this.hasProductCodes() == other.hasProductCodes() && Objects.equals(this.productCodes(), other.productCodes());
    }

    public final String toString() {
        return ToString.builder((String)"LicenseConversionContext").add("UsageOperation", (Object)this.usageOperation()).add("ProductCodes", this.hasProductCodes() ? this.productCodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UsageOperation": {
                return Optional.ofNullable(clazz.cast(this.usageOperation()));
            }
            case "ProductCodes": {
                return Optional.ofNullable(clazz.cast(this.productCodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("UsageOperation", USAGE_OPERATION_FIELD);
        map.put("ProductCodes", PRODUCT_CODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseConversionContext, T> g) {
        return obj -> g.apply((LicenseConversionContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String usageOperation;
        private List<ProductCodeListItem> productCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseConversionContext model) {
            this.usageOperation(model.usageOperation);
            this.productCodes(model.productCodes);
        }

        public final String getUsageOperation() {
            return this.usageOperation;
        }

        public final void setUsageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
        }

        @Override
        public final Builder usageOperation(String usageOperation) {
            this.usageOperation = usageOperation;
            return this;
        }

        public final List<ProductCodeListItem.Builder> getProductCodes() {
            List<ProductCodeListItem.Builder> result = ProductCodeListCopier.copyToBuilder(this.productCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductCodes(Collection<ProductCodeListItem.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        @Override
        public final Builder productCodes(Collection<ProductCodeListItem> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCodeListItem ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCodeListItem.Builder> ... productCodes) {
            this.productCodes(Stream.of(productCodes).map(c -> (ProductCodeListItem)((ProductCodeListItem.Builder)ProductCodeListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LicenseConversionContext build() {
            return new LicenseConversionContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LicenseConversionContext> {
        public Builder usageOperation(String var1);

        public Builder productCodes(Collection<ProductCodeListItem> var1);

        public Builder productCodes(ProductCodeListItem ... var1);

        public Builder productCodes(Consumer<ProductCodeListItem.Builder> ... var1);
    }
}

