/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TokenType {
    REFRESH_TOKEN("REFRESH_TOKEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TokenType> VALUE_MAP;
    private final String value;

    private TokenType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TokenType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TokenType> knownValues() {
        EnumSet<TokenType> knownValues = EnumSet.allOf(TokenType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TokenType.class, TokenType::toString);
    }
}

