/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.EntitlementData;
import software.amazon.awssdk.services.licensemanager.model.EntitlementDataListCopier;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.Metadata;
import software.amazon.awssdk.services.licensemanager.model.MetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckoutBorrowLicenseResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CheckoutBorrowLicenseResponse> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::licenseArn)).setter(CheckoutBorrowLicenseResponse.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> LICENSE_CONSUMPTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseConsumptionToken").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::licenseConsumptionToken)).setter(CheckoutBorrowLicenseResponse.setter(Builder::licenseConsumptionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseConsumptionToken").build()}).build();
    private static final SdkField<List<EntitlementData>> ENTITLEMENTS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EntitlementsAllowed").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::entitlementsAllowed)).setter(CheckoutBorrowLicenseResponse.setter(Builder::entitlementsAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementsAllowed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntitlementData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::nodeId)).setter(CheckoutBorrowLicenseResponse.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> SIGNED_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignedToken").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::signedToken)).setter(CheckoutBorrowLicenseResponse.setter(Builder::signedToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedToken").build()}).build();
    private static final SdkField<String> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IssuedAt").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::issuedAt)).setter(CheckoutBorrowLicenseResponse.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuedAt").build()}).build();
    private static final SdkField<String> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expiration").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::expiration)).setter(CheckoutBorrowLicenseResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()}).build();
    private static final SdkField<List<Metadata>> CHECKOUT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CheckoutMetadata").getter(CheckoutBorrowLicenseResponse.getter(CheckoutBorrowLicenseResponse::checkoutMetadata)).setter(CheckoutBorrowLicenseResponse.setter(Builder::checkoutMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckoutMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Metadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, LICENSE_CONSUMPTION_TOKEN_FIELD, ENTITLEMENTS_ALLOWED_FIELD, NODE_ID_FIELD, SIGNED_TOKEN_FIELD, ISSUED_AT_FIELD, EXPIRATION_FIELD, CHECKOUT_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CheckoutBorrowLicenseResponse.memberNameToFieldInitializer();
    private final String licenseArn;
    private final String licenseConsumptionToken;
    private final List<EntitlementData> entitlementsAllowed;
    private final String nodeId;
    private final String signedToken;
    private final String issuedAt;
    private final String expiration;
    private final List<Metadata> checkoutMetadata;

    private CheckoutBorrowLicenseResponse(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.licenseConsumptionToken = builder.licenseConsumptionToken;
        this.entitlementsAllowed = builder.entitlementsAllowed;
        this.nodeId = builder.nodeId;
        this.signedToken = builder.signedToken;
        this.issuedAt = builder.issuedAt;
        this.expiration = builder.expiration;
        this.checkoutMetadata = builder.checkoutMetadata;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String licenseConsumptionToken() {
        return this.licenseConsumptionToken;
    }

    public final boolean hasEntitlementsAllowed() {
        return this.entitlementsAllowed != null && !(this.entitlementsAllowed instanceof SdkAutoConstructList);
    }

    public final List<EntitlementData> entitlementsAllowed() {
        return this.entitlementsAllowed;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String signedToken() {
        return this.signedToken;
    }

    public final String issuedAt() {
        return this.issuedAt;
    }

    public final String expiration() {
        return this.expiration;
    }

    public final boolean hasCheckoutMetadata() {
        return this.checkoutMetadata != null && !(this.checkoutMetadata instanceof SdkAutoConstructList);
    }

    public final List<Metadata> checkoutMetadata() {
        return this.checkoutMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseConsumptionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntitlementsAllowed() ? this.entitlementsAllowed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCheckoutMetadata() ? this.checkoutMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutBorrowLicenseResponse)) {
            return false;
        }
        CheckoutBorrowLicenseResponse other = (CheckoutBorrowLicenseResponse)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.licenseConsumptionToken(), other.licenseConsumptionToken()) && this.hasEntitlementsAllowed() == other.hasEntitlementsAllowed() && Objects.equals(this.entitlementsAllowed(), other.entitlementsAllowed()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.signedToken(), other.signedToken()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.expiration(), other.expiration()) && this.hasCheckoutMetadata() == other.hasCheckoutMetadata() && Objects.equals(this.checkoutMetadata(), other.checkoutMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"CheckoutBorrowLicenseResponse").add("LicenseArn", (Object)this.licenseArn()).add("LicenseConsumptionToken", (Object)this.licenseConsumptionToken()).add("EntitlementsAllowed", this.hasEntitlementsAllowed() ? this.entitlementsAllowed() : null).add("NodeId", (Object)this.nodeId()).add("SignedToken", (Object)this.signedToken()).add("IssuedAt", (Object)this.issuedAt()).add("Expiration", (Object)this.expiration()).add("CheckoutMetadata", this.hasCheckoutMetadata() ? this.checkoutMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "LicenseConsumptionToken": {
                return Optional.ofNullable(clazz.cast(this.licenseConsumptionToken()));
            }
            case "EntitlementsAllowed": {
                return Optional.ofNullable(clazz.cast(this.entitlementsAllowed()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "SignedToken": {
                return Optional.ofNullable(clazz.cast(this.signedToken()));
            }
            case "IssuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
            case "CheckoutMetadata": {
                return Optional.ofNullable(clazz.cast(this.checkoutMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LicenseArn", LICENSE_ARN_FIELD);
        map.put("LicenseConsumptionToken", LICENSE_CONSUMPTION_TOKEN_FIELD);
        map.put("EntitlementsAllowed", ENTITLEMENTS_ALLOWED_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("SignedToken", SIGNED_TOKEN_FIELD);
        map.put("IssuedAt", ISSUED_AT_FIELD);
        map.put("Expiration", EXPIRATION_FIELD);
        map.put("CheckoutMetadata", CHECKOUT_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CheckoutBorrowLicenseResponse, T> g) {
        return obj -> g.apply((CheckoutBorrowLicenseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String licenseArn;
        private String licenseConsumptionToken;
        private List<EntitlementData> entitlementsAllowed = DefaultSdkAutoConstructList.getInstance();
        private String nodeId;
        private String signedToken;
        private String issuedAt;
        private String expiration;
        private List<Metadata> checkoutMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CheckoutBorrowLicenseResponse model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.licenseConsumptionToken(model.licenseConsumptionToken);
            this.entitlementsAllowed(model.entitlementsAllowed);
            this.nodeId(model.nodeId);
            this.signedToken(model.signedToken);
            this.issuedAt(model.issuedAt);
            this.expiration(model.expiration);
            this.checkoutMetadata(model.checkoutMetadata);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getLicenseConsumptionToken() {
            return this.licenseConsumptionToken;
        }

        public final void setLicenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
        }

        @Override
        public final Builder licenseConsumptionToken(String licenseConsumptionToken) {
            this.licenseConsumptionToken = licenseConsumptionToken;
            return this;
        }

        public final List<EntitlementData.Builder> getEntitlementsAllowed() {
            List<EntitlementData.Builder> result = EntitlementDataListCopier.copyToBuilder(this.entitlementsAllowed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntitlementsAllowed(Collection<EntitlementData.BuilderImpl> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copyFromBuilder(entitlementsAllowed);
        }

        @Override
        public final Builder entitlementsAllowed(Collection<EntitlementData> entitlementsAllowed) {
            this.entitlementsAllowed = EntitlementDataListCopier.copy(entitlementsAllowed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(EntitlementData ... entitlementsAllowed) {
            this.entitlementsAllowed(Arrays.asList(entitlementsAllowed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entitlementsAllowed(Consumer<EntitlementData.Builder> ... entitlementsAllowed) {
            this.entitlementsAllowed(Stream.of(entitlementsAllowed).map(c -> (EntitlementData)((EntitlementData.Builder)EntitlementData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getSignedToken() {
            return this.signedToken;
        }

        public final void setSignedToken(String signedToken) {
            this.signedToken = signedToken;
        }

        @Override
        public final Builder signedToken(String signedToken) {
            this.signedToken = signedToken;
            return this;
        }

        public final String getIssuedAt() {
            return this.issuedAt;
        }

        public final void setIssuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
        }

        @Override
        public final Builder issuedAt(String issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final String getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final List<Metadata.Builder> getCheckoutMetadata() {
            List<Metadata.Builder> result = MetadataListCopier.copyToBuilder(this.checkoutMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCheckoutMetadata(Collection<Metadata.BuilderImpl> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copyFromBuilder(checkoutMetadata);
        }

        @Override
        public final Builder checkoutMetadata(Collection<Metadata> checkoutMetadata) {
            this.checkoutMetadata = MetadataListCopier.copy(checkoutMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Metadata ... checkoutMetadata) {
            this.checkoutMetadata(Arrays.asList(checkoutMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder checkoutMetadata(Consumer<Metadata.Builder> ... checkoutMetadata) {
            this.checkoutMetadata(Stream.of(checkoutMetadata).map(c -> (Metadata)((Metadata.Builder)Metadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CheckoutBorrowLicenseResponse build() {
            return new CheckoutBorrowLicenseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckoutBorrowLicenseResponse> {
        public Builder licenseArn(String var1);

        public Builder licenseConsumptionToken(String var1);

        public Builder entitlementsAllowed(Collection<EntitlementData> var1);

        public Builder entitlementsAllowed(EntitlementData ... var1);

        public Builder entitlementsAllowed(Consumer<EntitlementData.Builder> ... var1);

        public Builder nodeId(String var1);

        public Builder signedToken(String var1);

        public Builder issuedAt(String var1);

        public Builder expiration(String var1);

        public Builder checkoutMetadata(Collection<Metadata> var1);

        public Builder checkoutMetadata(Metadata ... var1);

        public Builder checkoutMetadata(Consumer<Metadata.Builder> ... var1);
    }
}

