/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActivationOverrideBehavior {
    DISTRIBUTED_GRANTS_ONLY("DISTRIBUTED_GRANTS_ONLY"),
    ALL_GRANTS_PERMITTED_BY_ISSUER("ALL_GRANTS_PERMITTED_BY_ISSUER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActivationOverrideBehavior> VALUE_MAP;
    private final String value;

    private ActivationOverrideBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActivationOverrideBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActivationOverrideBehavior> knownValues() {
        EnumSet<ActivationOverrideBehavior> knownValues = EnumSet.allOf(ActivationOverrideBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActivationOverrideBehavior.class, ActivationOverrideBehavior::toString);
    }
}

