/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.EntitlementDataUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitlementUsage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitlementUsage> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EntitlementUsage.getter(EntitlementUsage::name)).setter(EntitlementUsage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONSUMED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumedValue").getter(EntitlementUsage.getter(EntitlementUsage::consumedValue)).setter(EntitlementUsage.setter(Builder::consumedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedValue").build()}).build();
    private static final SdkField<String> MAX_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxCount").getter(EntitlementUsage.getter(EntitlementUsage::maxCount)).setter(EntitlementUsage.setter(Builder::maxCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCount").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(EntitlementUsage.getter(EntitlementUsage::unitAsString)).setter(EntitlementUsage.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONSUMED_VALUE_FIELD, MAX_COUNT_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String consumedValue;
    private final String maxCount;
    private final String unit;

    private EntitlementUsage(BuilderImpl builder) {
        this.name = builder.name;
        this.consumedValue = builder.consumedValue;
        this.maxCount = builder.maxCount;
        this.unit = builder.unit;
    }

    public final String name() {
        return this.name;
    }

    public final String consumedValue() {
        return this.consumedValue;
    }

    public final String maxCount() {
        return this.maxCount;
    }

    public final EntitlementDataUnit unit() {
        return EntitlementDataUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitlementUsage)) {
            return false;
        }
        EntitlementUsage other = (EntitlementUsage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.consumedValue(), other.consumedValue()) && Objects.equals(this.maxCount(), other.maxCount()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EntitlementUsage").add("Name", (Object)this.name()).add("ConsumedValue", (Object)this.consumedValue()).add("MaxCount", (Object)this.maxCount()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConsumedValue": {
                return Optional.ofNullable(clazz.cast(this.consumedValue()));
            }
            case "MaxCount": {
                return Optional.ofNullable(clazz.cast(this.maxCount()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntitlementUsage, T> g) {
        return obj -> g.apply((EntitlementUsage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String consumedValue;
        private String maxCount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(EntitlementUsage model) {
            this.name(model.name);
            this.consumedValue(model.consumedValue);
            this.maxCount(model.maxCount);
            this.unit(model.unit);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConsumedValue() {
            return this.consumedValue;
        }

        public final void setConsumedValue(String consumedValue) {
            this.consumedValue = consumedValue;
        }

        @Override
        @Transient
        public final Builder consumedValue(String consumedValue) {
            this.consumedValue = consumedValue;
            return this;
        }

        public final String getMaxCount() {
            return this.maxCount;
        }

        public final void setMaxCount(String maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        @Transient
        public final Builder maxCount(String maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        @Transient
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        @Transient
        public final Builder unit(EntitlementDataUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public EntitlementUsage build() {
            return new EntitlementUsage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitlementUsage> {
        public Builder name(String var1);

        public Builder consumedValue(String var1);

        public Builder maxCount(String var1);

        public Builder unit(String var1);

        public Builder unit(EntitlementDataUnit var1);
    }
}

