/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.licensemanager.model.LicenseManagerResponse;
import software.amazon.awssdk.services.licensemanager.model.LicenseStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLicenseVersionResponse
extends LicenseManagerResponse
implements ToCopyableBuilder<Builder, CreateLicenseVersionResponse> {
    private static final SdkField<String> LICENSE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseArn").getter(CreateLicenseVersionResponse.getter(CreateLicenseVersionResponse::licenseArn)).setter(CreateLicenseVersionResponse.setter(Builder::licenseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(CreateLicenseVersionResponse.getter(CreateLicenseVersionResponse::version)).setter(CreateLicenseVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateLicenseVersionResponse.getter(CreateLicenseVersionResponse::statusAsString)).setter(CreateLicenseVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ARN_FIELD, VERSION_FIELD, STATUS_FIELD));
    private final String licenseArn;
    private final String version;
    private final String status;

    private CreateLicenseVersionResponse(BuilderImpl builder) {
        super(builder);
        this.licenseArn = builder.licenseArn;
        this.version = builder.version;
        this.status = builder.status;
    }

    public final String licenseArn() {
        return this.licenseArn;
    }

    public final String version() {
        return this.version;
    }

    public final LicenseStatus status() {
        return LicenseStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLicenseVersionResponse)) {
            return false;
        }
        CreateLicenseVersionResponse other = (CreateLicenseVersionResponse)((Object)obj);
        return Objects.equals(this.licenseArn(), other.licenseArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLicenseVersionResponse").add("LicenseArn", (Object)this.licenseArn()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LicenseArn": {
                return Optional.ofNullable(clazz.cast(this.licenseArn()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLicenseVersionResponse, T> g) {
        return obj -> g.apply((CreateLicenseVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LicenseManagerResponse.BuilderImpl
    implements Builder {
        private String licenseArn;
        private String version;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLicenseVersionResponse model) {
            super(model);
            this.licenseArn(model.licenseArn);
            this.version(model.version);
            this.status(model.status);
        }

        public final String getLicenseArn() {
            return this.licenseArn;
        }

        public final void setLicenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
        }

        @Override
        @Transient
        public final Builder licenseArn(String licenseArn) {
            this.licenseArn = licenseArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(LicenseStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateLicenseVersionResponse build() {
            return new CreateLicenseVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LicenseManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLicenseVersionResponse> {
        public Builder licenseArn(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(LicenseStatus var1);
    }
}

