/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the license configuration that this generator reports on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportContext implements SdkPojo, Serializable, ToCopyableBuilder<ReportContext.Builder, ReportContext> {
    private static final SdkField<List<String>> LICENSE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("licenseConfigurationArns")
            .getter(getter(ReportContext::licenseConfigurationArns))
            .setter(setter(Builder::licenseConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LICENSE_CONFIGURATION_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> licenseConfigurationArns;

    private ReportContext(BuilderImpl builder) {
        this.licenseConfigurationArns = builder.licenseConfigurationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLicenseConfigurationArns() {
        return licenseConfigurationArns != null && !(licenseConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the license configuration that this generator reports on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseConfigurationArns} method.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the license configuration that this generator reports on.
     */
    public final List<String> licenseConfigurationArns() {
        return licenseConfigurationArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseConfigurationArns() ? licenseConfigurationArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportContext)) {
            return false;
        }
        ReportContext other = (ReportContext) obj;
        return hasLicenseConfigurationArns() == other.hasLicenseConfigurationArns()
                && Objects.equals(licenseConfigurationArns(), other.licenseConfigurationArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportContext")
                .add("LicenseConfigurationArns", hasLicenseConfigurationArns() ? licenseConfigurationArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "licenseConfigurationArns":
            return Optional.ofNullable(clazz.cast(licenseConfigurationArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportContext, T> g) {
        return obj -> g.apply((ReportContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportContext> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration that this generator reports on.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        Amazon Resource Name (ARN) of the license configuration that this generator reports on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the license configuration that this generator reports on.
         * </p>
         * 
         * @param licenseConfigurationArns
         *        Amazon Resource Name (ARN) of the license configuration that this generator reports on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseConfigurationArns(String... licenseConfigurationArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> licenseConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReportContext model) {
            licenseConfigurationArns(model.licenseConfigurationArns);
        }

        public final Collection<String> getLicenseConfigurationArns() {
            if (licenseConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return licenseConfigurationArns;
        }

        public final void setLicenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = ArnListCopier.copy(licenseConfigurationArns);
        }

        @Override
        @Transient
        public final Builder licenseConfigurationArns(Collection<String> licenseConfigurationArns) {
            this.licenseConfigurationArns = ArnListCopier.copy(licenseConfigurationArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder licenseConfigurationArns(String... licenseConfigurationArns) {
            licenseConfigurationArns(Arrays.asList(licenseConfigurationArns));
            return this;
        }

        @Override
        public ReportContext build() {
            return new ReportContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
