/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceInventoryRequest extends LicenseManagerRequest implements
        ToCopyableBuilder<ListResourceInventoryRequest.Builder, ListResourceInventoryRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceInventoryRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceInventoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<InventoryFilter>> FILTERS_FIELD = SdkField
            .<List<InventoryFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListResourceInventoryRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, FILTERS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final List<InventoryFilter> filters;

    private ListResourceInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * Maximum number of results to return in a single call.
     * </p>
     * 
     * @return Maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Token for the next set of results.
     * </p>
     * 
     * @return Token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters to scope the results. The following filters and logical operators are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators are
     * <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> |
     * <code>BEGINS_WITH</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> |
     * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
     * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
     * <code>BEGINS_WITH</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
     * <code>NOT_EQUALS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical operators are
     * <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters to scope the results. The following filters and logical operators are supported:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical
     *         operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> |
     *         <code>BEGINS_WITH</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> |
     *         <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
     *         <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
     *         <code>BEGINS_WITH</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
     *         <code>NOT_EQUALS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical
     *         operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code>
     *         (cross account).
     *         </p>
     *         </li>
     */
    public final List<InventoryFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceInventoryRequest)) {
            return false;
        }
        ListResourceInventoryRequest other = (ListResourceInventoryRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceInventoryRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceInventoryRequest, T> g) {
        return obj -> g.apply((ListResourceInventoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceInventoryRequest> {
        /**
         * <p>
         * Maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators
         * are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical operators
         * are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical
         *        operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code>
         *        | <code>BEGINS_WITH</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>license_included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code>
         *        | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
         *        <code>BEGINS_WITH</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
         *        <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical
         *        operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code>
         *        (cross account).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators
         * are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical operators
         * are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters to scope the results. The following filters and logical operators are supported:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical
         *        operators are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code>
         *        | <code>BEGINS_WITH</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>license_included</code> - The type of license included. Logical operators are
         *        <code>EQUALS</code> | <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code>
         *        | <code>sql-server-standard</code> | <code>sql-server-web</code> |
         *        <code>windows-server-datacenter</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
         *        <code>BEGINS_WITH</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
         *        <code>NOT_EQUALS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical
         *        operators are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code>
         *        (cross account).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * Filters to scope the results. The following filters and logical operators are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>account_id</code> - The ID of the Amazon Web Services account that owns the resource. Logical operators
         * are <code>EQUALS</code> | <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application_name</code> - The name of the application. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>license_included</code> - The type of license included. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>. Possible values are <code>sql-server-enterprise</code> |
         * <code>sql-server-standard</code> | <code>sql-server-web</code> | <code>windows-server-datacenter</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform of the resource. Logical operators are <code>EQUALS</code> |
         * <code>BEGINS_WITH</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resource_id</code> - The ID of the resource. Logical operators are <code>EQUALS</code> |
         * <code>NOT_EQUALS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag:&lt;key&gt;</code> - The key/value combination of a tag assigned to the resource. Logical operators
         * are <code>EQUALS</code> (single account) or <code>EQUALS</code> | <code>NOT_EQUALS</code> (cross account).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<InventoryFilter>.Builder} avoiding the need
         * to create one manually via {@link List<InventoryFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<InventoryFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<InventoryFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<InventoryFilter>)
         */
        Builder filters(Consumer<InventoryFilter.Builder>... filters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LicenseManagerRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private List<InventoryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceInventoryRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            filters(model.filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InventoryFilter.Builder> getFilters() {
            List<InventoryFilter.Builder> result = InventoryFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<InventoryFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> InventoryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceInventoryRequest build() {
            return new ListResourceInventoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
