/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a time range, in ISO8601-UTC format.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatetimeRange implements SdkPojo, Serializable, ToCopyableBuilder<DatetimeRange.Builder, DatetimeRange> {
    private static final SdkField<String> BEGIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Begin")
            .getter(getter(DatetimeRange::begin)).setter(setter(Builder::begin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Begin").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("End")
            .getter(getter(DatetimeRange::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final String begin;

    private final String end;

    private DatetimeRange(BuilderImpl builder) {
        this.begin = builder.begin;
        this.end = builder.end;
    }

    /**
     * <p>
     * Start of the time range.
     * </p>
     * 
     * @return Start of the time range.
     */
    public final String begin() {
        return begin;
    }

    /**
     * <p>
     * End of the time range.
     * </p>
     * 
     * @return End of the time range.
     */
    public final String end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(begin());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatetimeRange)) {
            return false;
        }
        DatetimeRange other = (DatetimeRange) obj;
        return Objects.equals(begin(), other.begin()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatetimeRange").add("Begin", begin()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Begin":
            return Optional.ofNullable(clazz.cast(begin()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatetimeRange, T> g) {
        return obj -> g.apply((DatetimeRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatetimeRange> {
        /**
         * <p>
         * Start of the time range.
         * </p>
         * 
         * @param begin
         *        Start of the time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder begin(String begin);

        /**
         * <p>
         * End of the time range.
         * </p>
         * 
         * @param end
         *        End of the time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);
    }

    static final class BuilderImpl implements Builder {
        private String begin;

        private String end;

        private BuilderImpl() {
        }

        private BuilderImpl(DatetimeRange model) {
            begin(model.begin);
            end(model.end);
        }

        public final String getBegin() {
            return begin;
        }

        public final void setBegin(String begin) {
            this.begin = begin;
        }

        @Override
        @Transient
        public final Builder begin(String begin) {
            this.begin = begin;
            return this;
        }

        public final String getEnd() {
            return end;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        @Transient
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        @Override
        public DatetimeRange build() {
            return new DatetimeRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
