/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.licensemanager.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTokenResponse extends LicenseManagerResponse implements
        ToCopyableBuilder<CreateTokenResponse.Builder, CreateTokenResponse> {
    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenId").getter(getter(CreateTokenResponse::tokenId)).setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenId").build()).build();

    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TokenType").getter(getter(CreateTokenResponse::tokenTypeAsString)).setter(setter(Builder::tokenType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenType").build()).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Token")
            .getter(getter(CreateTokenResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_ID_FIELD,
            TOKEN_TYPE_FIELD, TOKEN_FIELD));

    private final String tokenId;

    private final String tokenType;

    private final String token;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.tokenId = builder.tokenId;
        this.tokenType = builder.tokenType;
        this.token = builder.token;
    }

    /**
     * <p>
     * Token ID.
     * </p>
     * 
     * @return Token ID.
     */
    public final String tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * Token type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenType} will
     * return {@link TokenType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tokenTypeAsString}.
     * </p>
     * 
     * @return Token type.
     * @see TokenType
     */
    public final TokenType tokenType() {
        return TokenType.fromValue(tokenType);
    }

    /**
     * <p>
     * Token type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenType} will
     * return {@link TokenType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tokenTypeAsString}.
     * </p>
     * 
     * @return Token type.
     * @see TokenType
     */
    public final String tokenTypeAsString() {
        return tokenType;
    }

    /**
     * <p>
     * Refresh token, encoded as a JWT token.
     * </p>
     * 
     * @return Refresh token, encoded as a JWT token.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse) obj;
        return Objects.equals(tokenId(), other.tokenId()) && Objects.equals(tokenTypeAsString(), other.tokenTypeAsString())
                && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTokenResponse").add("TokenId", tokenId()).add("TokenType", tokenTypeAsString())
                .add("Token", token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "TokenType":
            return Optional.ofNullable(clazz.cast(tokenTypeAsString()));
        case "Token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LicenseManagerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTokenResponse> {
        /**
         * <p>
         * Token ID.
         * </p>
         * 
         * @param tokenId
         *        Token ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(String tokenId);

        /**
         * <p>
         * Token type.
         * </p>
         * 
         * @param tokenType
         *        Token type.
         * @see TokenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenType
         */
        Builder tokenType(String tokenType);

        /**
         * <p>
         * Token type.
         * </p>
         * 
         * @param tokenType
         *        Token type.
         * @see TokenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TokenType
         */
        Builder tokenType(TokenType tokenType);

        /**
         * <p>
         * Refresh token, encoded as a JWT token.
         * </p>
         * 
         * @param token
         *        Refresh token, encoded as a JWT token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl extends LicenseManagerResponse.BuilderImpl implements Builder {
        private String tokenId;

        private String tokenType;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            tokenId(model.tokenId);
            tokenType(model.tokenType);
            token(model.token);
        }

        public final String getTokenId() {
            return tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        @Transient
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTokenType() {
            return tokenType;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        @Transient
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @Override
        @Transient
        public final Builder tokenType(TokenType tokenType) {
            this.tokenType(tokenType == null ? null : tokenType.toString());
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        @Transient
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
