/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.LexRuntimeV2Request;
import software.amazon.awssdk.services.lexruntimev2.model.SessionState;
import software.amazon.awssdk.services.lexruntimev2.model.StringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecognizeTextRequest
extends LexRuntimeV2Request
implements ToCopyableBuilder<Builder, RecognizeTextRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(RecognizeTextRequest.getter(RecognizeTextRequest::botId)).setter(RecognizeTextRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_ALIAS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botAliasId").getter(RecognizeTextRequest.getter(RecognizeTextRequest::botAliasId)).setter(RecognizeTextRequest.setter(Builder::botAliasId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botAliasId").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(RecognizeTextRequest.getter(RecognizeTextRequest::localeId)).setter(RecognizeTextRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(RecognizeTextRequest.getter(RecognizeTextRequest::sessionId)).setter(RecognizeTextRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(RecognizeTextRequest.getter(RecognizeTextRequest::text)).setter(RecognizeTextRequest.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(RecognizeTextRequest.getter(RecognizeTextRequest::sessionState)).setter(RecognizeTextRequest.setter(Builder::sessionState)).constructor(SessionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(RecognizeTextRequest.getter(RecognizeTextRequest::requestAttributes)).setter(RecognizeTextRequest.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_ALIAS_ID_FIELD, LOCALE_ID_FIELD, SESSION_ID_FIELD, TEXT_FIELD, SESSION_STATE_FIELD, REQUEST_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecognizeTextRequest.memberNameToFieldInitializer();
    private final String botId;
    private final String botAliasId;
    private final String localeId;
    private final String sessionId;
    private final String text;
    private final SessionState sessionState;
    private final Map<String, String> requestAttributes;

    private RecognizeTextRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botAliasId = builder.botAliasId;
        this.localeId = builder.localeId;
        this.sessionId = builder.sessionId;
        this.text = builder.text;
        this.sessionState = builder.sessionState;
        this.requestAttributes = builder.requestAttributes;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botAliasId() {
        return this.botAliasId;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String text() {
        return this.text;
    }

    public final SessionState sessionState() {
        return this.sessionState;
    }

    public final boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestAttributes() ? this.requestAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecognizeTextRequest)) {
            return false;
        }
        RecognizeTextRequest other = (RecognizeTextRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botAliasId(), other.botAliasId()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.sessionState(), other.sessionState()) && this.hasRequestAttributes() == other.hasRequestAttributes() && Objects.equals(this.requestAttributes(), other.requestAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"RecognizeTextRequest").add("BotId", (Object)this.botId()).add("BotAliasId", (Object)this.botAliasId()).add("LocaleId", (Object)this.localeId()).add("SessionId", (Object)this.sessionId()).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionState", (Object)this.sessionState()).add("RequestAttributes", this.hasRequestAttributes() ? this.requestAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botAliasId": {
                return Optional.ofNullable(clazz.cast(this.botAliasId()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botAliasId", BOT_ALIAS_ID_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("sessionState", SESSION_STATE_FIELD);
        map.put("requestAttributes", REQUEST_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecognizeTextRequest, T> g) {
        return obj -> g.apply((RecognizeTextRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexRuntimeV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botAliasId;
        private String localeId;
        private String sessionId;
        private String text;
        private SessionState sessionState;
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecognizeTextRequest model) {
            super(model);
            this.botId(model.botId);
            this.botAliasId(model.botAliasId);
            this.localeId(model.localeId);
            this.sessionId(model.sessionId);
            this.text(model.text);
            this.sessionState(model.sessionState);
            this.requestAttributes(model.requestAttributes);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotAliasId() {
            return this.botAliasId;
        }

        public final void setBotAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
        }

        @Override
        public final Builder botAliasId(String botAliasId) {
            this.botAliasId = botAliasId;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final SessionState.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (this.requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RecognizeTextRequest build() {
            return new RecognizeTextRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LexRuntimeV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RecognizeTextRequest> {
        public Builder botId(String var1);

        public Builder botAliasId(String var1);

        public Builder localeId(String var1);

        public Builder sessionId(String var1);

        public Builder text(String var1);

        public Builder sessionState(SessionState var1);

        default public Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return this.sessionState((SessionState)((SessionState.Builder)SessionState.builder().applyMutation(sessionState)).build());
        }

        public Builder requestAttributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

