/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InterpretationSource {
    BEDROCK("Bedrock"),
    LEX("Lex"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InterpretationSource> VALUE_MAP;
    private final String value;

    private InterpretationSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InterpretationSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InterpretationSource> knownValues() {
        EnumSet<InterpretationSource> knownValues = EnumSet.allOf(InterpretationSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InterpretationSource.class, InterpretationSource::toString);
    }
}

