/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexruntimev2.model.ConfirmationState;
import software.amazon.awssdk.services.lexruntimev2.model.IntentState;
import software.amazon.awssdk.services.lexruntimev2.model.Slot;
import software.amazon.awssdk.services.lexruntimev2.model.SlotsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Intent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Intent> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Intent.getter(Intent::name)).setter(Intent.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, Slot>> SLOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slots").getter(Intent.getter(Intent::slots)).setter(Intent.setter(Builder::slots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Slot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Intent.getter(Intent::stateAsString)).setter(Intent.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> CONFIRMATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationState").getter(Intent.getter(Intent::confirmationStateAsString)).setter(Intent.setter(Builder::confirmationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SLOTS_FIELD, STATE_FIELD, CONFIRMATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Intent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, Slot> slots;
    private final String state;
    private final String confirmationState;

    private Intent(BuilderImpl builder) {
        this.name = builder.name;
        this.slots = builder.slots;
        this.state = builder.state;
        this.confirmationState = builder.confirmationState;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSlots() {
        return this.slots != null && !(this.slots instanceof SdkAutoConstructMap);
    }

    public final Map<String, Slot> slots() {
        return this.slots;
    }

    public final IntentState state() {
        return IntentState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final ConfirmationState confirmationState() {
        return ConfirmationState.fromValue(this.confirmationState);
    }

    public final String confirmationStateAsString() {
        return this.confirmationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlots() ? this.slots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Intent)) {
            return false;
        }
        Intent other = (Intent)obj;
        return Objects.equals(this.name(), other.name()) && this.hasSlots() == other.hasSlots() && Objects.equals(this.slots(), other.slots()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.confirmationStateAsString(), other.confirmationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Intent").add("Name", (Object)this.name()).add("Slots", this.hasSlots() ? this.slots() : null).add("State", (Object)this.stateAsString()).add("ConfirmationState", (Object)this.confirmationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "slots": {
                return Optional.ofNullable(clazz.cast(this.slots()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "confirmationState": {
                return Optional.ofNullable(clazz.cast(this.confirmationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("slots", SLOTS_FIELD);
        map.put("state", STATE_FIELD);
        map.put("confirmationState", CONFIRMATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Intent, T> g) {
        return obj -> g.apply((Intent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, Slot> slots = DefaultSdkAutoConstructMap.getInstance();
        private String state;
        private String confirmationState;

        private BuilderImpl() {
        }

        private BuilderImpl(Intent model) {
            this.name(model.name);
            this.slots(model.slots);
            this.state(model.state);
            this.confirmationState(model.confirmationState);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, Slot.Builder> getSlots() {
            Map<String, Slot.Builder> result = SlotsCopier.copyToBuilder(this.slots);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSlots(Map<String, Slot.BuilderImpl> slots) {
            this.slots = SlotsCopier.copyFromBuilder(slots);
        }

        @Override
        public final Builder slots(Map<String, Slot> slots) {
            this.slots = SlotsCopier.copy(slots);
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(IntentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getConfirmationState() {
            return this.confirmationState;
        }

        public final void setConfirmationState(String confirmationState) {
            this.confirmationState = confirmationState;
        }

        @Override
        public final Builder confirmationState(String confirmationState) {
            this.confirmationState = confirmationState;
            return this;
        }

        @Override
        public final Builder confirmationState(ConfirmationState confirmationState) {
            this.confirmationState(confirmationState == null ? null : confirmationState.toString());
            return this;
        }

        public Intent build() {
            return new Intent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Intent> {
        public Builder name(String var1);

        public Builder slots(Map<String, Slot> var1);

        public Builder state(String var1);

        public Builder state(IntentState var1);

        public Builder confirmationState(String var1);

        public Builder confirmationState(ConfirmationState var1);
    }
}

