/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.lexruntimev2.DefaultLexRuntimeV2AsyncClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2AsyncClientBuilder;
import software.amazon.awssdk.services.lexruntimev2.LexRuntimeV2ServiceClientConfiguration;
import software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.DeleteSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.GetSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.GetSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.PutSessionRequest;
import software.amazon.awssdk.services.lexruntimev2.model.PutSessionResponse;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextRequest;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeTextResponse;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceRequest;
import software.amazon.awssdk.services.lexruntimev2.model.RecognizeUtteranceResponse;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequest;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationRequestEventStream;
import software.amazon.awssdk.services.lexruntimev2.model.StartConversationResponseHandler;

@SdkPublicApi
@ThreadSafe
public interface LexRuntimeV2AsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "lex";
    public static final String SERVICE_METADATA_ID = "runtime-v2-lex";

    default public CompletableFuture<DeleteSessionResponse> deleteSession(DeleteSessionRequest deleteSessionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DeleteSessionResponse> deleteSession(Consumer<DeleteSessionRequest.Builder> deleteSessionRequest) {
        return this.deleteSession((DeleteSessionRequest)((Object)((DeleteSessionRequest.Builder)DeleteSessionRequest.builder().applyMutation(deleteSessionRequest)).build()));
    }

    default public CompletableFuture<GetSessionResponse> getSession(GetSessionRequest getSessionRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSessionResponse> getSession(Consumer<GetSessionRequest.Builder> getSessionRequest) {
        return this.getSession((GetSessionRequest)((Object)((GetSessionRequest.Builder)GetSessionRequest.builder().applyMutation(getSessionRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> putSession(PutSessionRequest putSessionRequest, AsyncResponseTransformer<PutSessionResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, AsyncResponseTransformer<PutSessionResponse, ReturnT> asyncResponseTransformer) {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<PutSessionResponse> putSession(PutSessionRequest putSessionRequest, Path destinationPath) {
        return this.putSession(putSessionRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<PutSessionResponse> putSession(Consumer<PutSessionRequest.Builder> putSessionRequest, Path destinationPath) {
        return this.putSession((PutSessionRequest)((Object)((PutSessionRequest.Builder)PutSessionRequest.builder().applyMutation(putSessionRequest)).build()), destinationPath);
    }

    default public CompletableFuture<RecognizeTextResponse> recognizeText(RecognizeTextRequest recognizeTextRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<RecognizeTextResponse> recognizeText(Consumer<RecognizeTextRequest.Builder> recognizeTextRequest) {
        return this.recognizeText((RecognizeTextRequest)((Object)((RecognizeTextRequest.Builder)RecognizeTextRequest.builder().applyMutation(recognizeTextRequest)).build()));
    }

    default public <ReturnT> CompletableFuture<ReturnT> recognizeUtterance(RecognizeUtteranceRequest recognizeUtteranceRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<RecognizeUtteranceResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> recognizeUtterance(Consumer<RecognizeUtteranceRequest.Builder> recognizeUtteranceRequest, AsyncRequestBody requestBody, AsyncResponseTransformer<RecognizeUtteranceResponse, ReturnT> asyncResponseTransformer) {
        return this.recognizeUtterance((RecognizeUtteranceRequest)((Object)((RecognizeUtteranceRequest.Builder)RecognizeUtteranceRequest.builder().applyMutation(recognizeUtteranceRequest)).build()), requestBody, asyncResponseTransformer);
    }

    default public CompletableFuture<RecognizeUtteranceResponse> recognizeUtterance(RecognizeUtteranceRequest recognizeUtteranceRequest, Path sourcePath, Path destinationPath) {
        return this.recognizeUtterance(recognizeUtteranceRequest, AsyncRequestBody.fromFile((Path)sourcePath), AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<RecognizeUtteranceResponse> recognizeUtterance(Consumer<RecognizeUtteranceRequest.Builder> recognizeUtteranceRequest, Path sourcePath, Path destinationPath) {
        return this.recognizeUtterance((RecognizeUtteranceRequest)((Object)((RecognizeUtteranceRequest.Builder)RecognizeUtteranceRequest.builder().applyMutation(recognizeUtteranceRequest)).build()), sourcePath, destinationPath);
    }

    default public CompletableFuture<Void> startConversation(StartConversationRequest startConversationRequest, Publisher<StartConversationRequestEventStream> requestStream, StartConversationResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Void> startConversation(Consumer<StartConversationRequest.Builder> startConversationRequest, Publisher<StartConversationRequestEventStream> requestStream, StartConversationResponseHandler asyncResponseHandler) {
        return this.startConversation((StartConversationRequest)((Object)((StartConversationRequest.Builder)StartConversationRequest.builder().applyMutation(startConversationRequest)).build()), requestStream, asyncResponseHandler);
    }

    default public LexRuntimeV2ServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static LexRuntimeV2AsyncClient create() {
        return (LexRuntimeV2AsyncClient)LexRuntimeV2AsyncClient.builder().build();
    }

    public static LexRuntimeV2AsyncClientBuilder builder() {
        return new DefaultLexRuntimeV2AsyncClientBuilder();
    }
}

