/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotShape;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotValue;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotValueOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotValueOverride> {
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(SlotValueOverride.getter(SlotValueOverride::shapeAsString)).setter(SlotValueOverride.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<SlotValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(SlotValueOverride.getter(SlotValueOverride::value)).setter(SlotValueOverride.setter(Builder::value)).constructor(SlotValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<List<SlotValueOverride>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(SlotValueOverride.getter(SlotValueOverride::values)).setter(SlotValueOverride.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotValueOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHAPE_FIELD, VALUE_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SlotValueOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String shape;
    private final SlotValue value;
    private final List<SlotValueOverride> values;

    private SlotValueOverride(BuilderImpl builder) {
        this.shape = builder.shape;
        this.value = builder.value;
        this.values = builder.values;
    }

    public final SlotShape shape() {
        return SlotShape.fromValue(this.shape);
    }

    public final String shapeAsString() {
        return this.shape;
    }

    public final SlotValue value() {
        return this.value;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<SlotValueOverride> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shapeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotValueOverride)) {
            return false;
        }
        SlotValueOverride other = (SlotValueOverride)obj;
        return Objects.equals(this.shapeAsString(), other.shapeAsString()) && Objects.equals(this.value(), other.value()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"SlotValueOverride").add("Shape", (Object)this.shapeAsString()).add("Value", (Object)this.value()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shapeAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shape", SHAPE_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotValueOverride, T> g) {
        return obj -> g.apply((SlotValueOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shape;
        private SlotValue value;
        private List<SlotValueOverride> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotValueOverride model) {
            this.shape(model.shape);
            this.value(model.value);
            this.values(model.values);
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        @Override
        public final Builder shape(SlotShape shape) {
            this.shape(shape == null ? null : shape.toString());
            return this;
        }

        public final SlotValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(SlotValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(SlotValue value) {
            this.value = value;
            return this;
        }

        public final List<Builder> getValues() {
            List<Builder> result = SlotValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<BuilderImpl> values) {
            this.values = SlotValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<SlotValueOverride> values) {
            this.values = SlotValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(SlotValueOverride ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<Builder> ... values) {
            this.values(Stream.of(values).map(c -> (SlotValueOverride)((Builder)SlotValueOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SlotValueOverride build() {
            return new SlotValueOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotValueOverride> {
        public Builder shape(String var1);

        public Builder shape(SlotShape var1);

        public Builder value(SlotValue var1);

        default public Builder value(Consumer<SlotValue.Builder> value) {
            return this.value((SlotValue)((SlotValue.Builder)SlotValue.builder().applyMutation(value)).build());
        }

        public Builder values(Collection<SlotValueOverride> var1);

        public Builder values(SlotValueOverride ... var1);

        public Builder values(Consumer<Builder> ... var1);
    }
}

