/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.Specifications;
import software.amazon.awssdk.services.lexmodelsv2.model.SubSlotSpecificationMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubSlotSetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubSlotSetting> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(SubSlotSetting.getter(SubSlotSetting::expression)).setter(SubSlotSetting.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<Map<String, Specifications>> SLOT_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("slotSpecifications").getter(SubSlotSetting.getter(SubSlotSetting::slotSpecifications)).setter(SubSlotSetting.setter(Builder::slotSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotSpecifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Specifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, SLOT_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubSlotSetting.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final Map<String, Specifications> slotSpecifications;

    private SubSlotSetting(BuilderImpl builder) {
        this.expression = builder.expression;
        this.slotSpecifications = builder.slotSpecifications;
    }

    public final String expression() {
        return this.expression;
    }

    public final boolean hasSlotSpecifications() {
        return this.slotSpecifications != null && !(this.slotSpecifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, Specifications> slotSpecifications() {
        return this.slotSpecifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlotSpecifications() ? this.slotSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubSlotSetting)) {
            return false;
        }
        SubSlotSetting other = (SubSlotSetting)obj;
        return Objects.equals(this.expression(), other.expression()) && this.hasSlotSpecifications() == other.hasSlotSpecifications() && Objects.equals(this.slotSpecifications(), other.slotSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"SubSlotSetting").add("Expression", (Object)this.expression()).add("SlotSpecifications", this.hasSlotSpecifications() ? this.slotSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "slotSpecifications": {
                return Optional.ofNullable(clazz.cast(this.slotSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("expression", EXPRESSION_FIELD);
        map.put("slotSpecifications", SLOT_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubSlotSetting, T> g) {
        return obj -> g.apply((SubSlotSetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private Map<String, Specifications> slotSpecifications = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubSlotSetting model) {
            this.expression(model.expression);
            this.slotSpecifications(model.slotSpecifications);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Map<String, Specifications.Builder> getSlotSpecifications() {
            Map<String, Specifications.Builder> result = SubSlotSpecificationMapCopier.copyToBuilder(this.slotSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSlotSpecifications(Map<String, Specifications.BuilderImpl> slotSpecifications) {
            this.slotSpecifications = SubSlotSpecificationMapCopier.copyFromBuilder(slotSpecifications);
        }

        @Override
        public final Builder slotSpecifications(Map<String, Specifications> slotSpecifications) {
            this.slotSpecifications = SubSlotSpecificationMapCopier.copy(slotSpecifications);
            return this;
        }

        public SubSlotSetting build() {
            return new SubSlotSetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubSlotSetting> {
        public Builder expression(String var1);

        public Builder slotSpecifications(Map<String, Specifications> var1);
    }
}

