/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListAggregatedUtterancesResponse;

public class ListAggregatedUtterancesIterable
implements SdkIterable<ListAggregatedUtterancesResponse> {
    private final LexModelsV2Client client;
    private final ListAggregatedUtterancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAggregatedUtterancesIterable(LexModelsV2Client client, ListAggregatedUtterancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAggregatedUtterancesResponseFetcher();
    }

    public Iterator<ListAggregatedUtterancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAggregatedUtterancesResponseFetcher
    implements SyncPageFetcher<ListAggregatedUtterancesResponse> {
        private ListAggregatedUtterancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregatedUtterancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAggregatedUtterancesResponse nextPage(ListAggregatedUtterancesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregatedUtterancesIterable.this.client.listAggregatedUtterances(ListAggregatedUtterancesIterable.this.firstRequest);
            }
            return ListAggregatedUtterancesIterable.this.client.listAggregatedUtterances((ListAggregatedUtterancesRequest)((Object)ListAggregatedUtterancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

