/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.Message;
import software.amazon.awssdk.services.lexmodelsv2.model.MessageVariationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageGroup> {
    private static final SdkField<Message> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("message").getter(MessageGroup.getter(MessageGroup::message)).setter(MessageGroup.setter(Builder::message)).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<Message>> VARIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variations").getter(MessageGroup.getter(MessageGroup::variations)).setter(MessageGroup.setter(Builder::variations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Message::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, VARIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Message message;
    private final List<Message> variations;

    private MessageGroup(BuilderImpl builder) {
        this.message = builder.message;
        this.variations = builder.variations;
    }

    public final Message message() {
        return this.message;
    }

    public final boolean hasVariations() {
        return this.variations != null && !(this.variations instanceof SdkAutoConstructList);
    }

    public final List<Message> variations() {
        return this.variations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariations() ? this.variations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageGroup)) {
            return false;
        }
        MessageGroup other = (MessageGroup)obj;
        return Objects.equals(this.message(), other.message()) && this.hasVariations() == other.hasVariations() && Objects.equals(this.variations(), other.variations());
    }

    public final String toString() {
        return ToString.builder((String)"MessageGroup").add("Message", (Object)this.message()).add("Variations", this.hasVariations() ? this.variations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "variations": {
                return Optional.ofNullable(clazz.cast(this.variations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", MESSAGE_FIELD);
        map.put("variations", VARIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageGroup, T> g) {
        return obj -> g.apply((MessageGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Message message;
        private List<Message> variations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageGroup model) {
            this.message(model.message);
            this.variations(model.variations);
        }

        public final Message.Builder getMessage() {
            return this.message != null ? this.message.toBuilder() : null;
        }

        public final void setMessage(Message.BuilderImpl message) {
            this.message = message != null ? message.build() : null;
        }

        @Override
        public final Builder message(Message message) {
            this.message = message;
            return this;
        }

        public final List<Message.Builder> getVariations() {
            List<Message.Builder> result = MessageVariationsListCopier.copyToBuilder(this.variations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariations(Collection<Message.BuilderImpl> variations) {
            this.variations = MessageVariationsListCopier.copyFromBuilder(variations);
        }

        @Override
        public final Builder variations(Collection<Message> variations) {
            this.variations = MessageVariationsListCopier.copy(variations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Message ... variations) {
            this.variations(Arrays.asList(variations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variations(Consumer<Message.Builder> ... variations) {
            this.variations(Stream.of(variations).map(c -> (Message)((Message.Builder)Message.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MessageGroup build() {
            return new MessageGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageGroup> {
        public Builder message(Message var1);

        default public Builder message(Consumer<Message.Builder> message) {
            return this.message((Message)((Message.Builder)Message.builder().applyMutation(message)).build());
        }

        public Builder variations(Collection<Message> var1);

        public Builder variations(Message ... var1);

        public Builder variations(Consumer<Message.Builder> ... var1);
    }
}

