/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceAnalyticsDataResponse;

public class ListUtteranceAnalyticsDataPublisher
implements SdkPublisher<ListUtteranceAnalyticsDataResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListUtteranceAnalyticsDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUtteranceAnalyticsDataPublisher(LexModelsV2AsyncClient client, ListUtteranceAnalyticsDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUtteranceAnalyticsDataPublisher(LexModelsV2AsyncClient client, ListUtteranceAnalyticsDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUtteranceAnalyticsDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUtteranceAnalyticsDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUtteranceAnalyticsDataResponseFetcher
    implements AsyncPageFetcher<ListUtteranceAnalyticsDataResponse> {
        private ListUtteranceAnalyticsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListUtteranceAnalyticsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUtteranceAnalyticsDataResponse> nextPage(ListUtteranceAnalyticsDataResponse previousPage) {
            if (previousPage == null) {
                return ListUtteranceAnalyticsDataPublisher.this.client.listUtteranceAnalyticsData(ListUtteranceAnalyticsDataPublisher.this.firstRequest);
            }
            return ListUtteranceAnalyticsDataPublisher.this.client.listUtteranceAnalyticsData((ListUtteranceAnalyticsDataRequest)((Object)ListUtteranceAnalyticsDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

