/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListIntentStageMetricsResponse;

public class ListIntentStageMetricsIterable
implements SdkIterable<ListIntentStageMetricsResponse> {
    private final LexModelsV2Client client;
    private final ListIntentStageMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIntentStageMetricsIterable(LexModelsV2Client client, ListIntentStageMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIntentStageMetricsResponseFetcher();
    }

    public Iterator<ListIntentStageMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListIntentStageMetricsResponseFetcher
    implements SyncPageFetcher<ListIntentStageMetricsResponse> {
        private ListIntentStageMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListIntentStageMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIntentStageMetricsResponse nextPage(ListIntentStageMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListIntentStageMetricsIterable.this.client.listIntentStageMetrics(ListIntentStageMetricsIterable.this.firstRequest);
            }
            return ListIntentStageMetricsIterable.this.client.listIntentStageMetrics((ListIntentStageMetricsRequest)((Object)ListIntentStageMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

