/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BedrockKnowledgeStoreConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.OpensearchConfiguration;
import software.amazon.awssdk.services.lexmodelsv2.model.QnAKendraConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfiguration> {
    private static final SdkField<OpensearchConfiguration> OPENSEARCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("opensearchConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::opensearchConfiguration)).setter(DataSourceConfiguration.setter(Builder::opensearchConfiguration)).constructor(OpensearchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opensearchConfiguration").build()}).build();
    private static final SdkField<QnAKendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kendraConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::kendraConfiguration)).setter(DataSourceConfiguration.setter(Builder::kendraConfiguration)).constructor(QnAKendraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build()}).build();
    private static final SdkField<BedrockKnowledgeStoreConfiguration> BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("bedrockKnowledgeStoreConfiguration").getter(DataSourceConfiguration.getter(DataSourceConfiguration::bedrockKnowledgeStoreConfiguration)).setter(DataSourceConfiguration.setter(Builder::bedrockKnowledgeStoreConfiguration)).constructor(BedrockKnowledgeStoreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeStoreConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPENSEARCH_CONFIGURATION_FIELD, KENDRA_CONFIGURATION_FIELD, BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OpensearchConfiguration opensearchConfiguration;
    private final QnAKendraConfiguration kendraConfiguration;
    private final BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.opensearchConfiguration = builder.opensearchConfiguration;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.bedrockKnowledgeStoreConfiguration = builder.bedrockKnowledgeStoreConfiguration;
    }

    public final OpensearchConfiguration opensearchConfiguration() {
        return this.opensearchConfiguration;
    }

    public final QnAKendraConfiguration kendraConfiguration() {
        return this.kendraConfiguration;
    }

    public final BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration() {
        return this.bedrockKnowledgeStoreConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opensearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.bedrockKnowledgeStoreConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration)obj;
        return Objects.equals(this.opensearchConfiguration(), other.opensearchConfiguration()) && Objects.equals(this.kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(this.bedrockKnowledgeStoreConfiguration(), other.bedrockKnowledgeStoreConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfiguration").add("OpensearchConfiguration", (Object)this.opensearchConfiguration()).add("KendraConfiguration", (Object)this.kendraConfiguration()).add("BedrockKnowledgeStoreConfiguration", (Object)this.bedrockKnowledgeStoreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "opensearchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.opensearchConfiguration()));
            }
            case "kendraConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kendraConfiguration()));
            }
            case "bedrockKnowledgeStoreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.bedrockKnowledgeStoreConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("opensearchConfiguration", OPENSEARCH_CONFIGURATION_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("bedrockKnowledgeStoreConfiguration", BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OpensearchConfiguration opensearchConfiguration;
        private QnAKendraConfiguration kendraConfiguration;
        private BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            this.opensearchConfiguration(model.opensearchConfiguration);
            this.kendraConfiguration(model.kendraConfiguration);
            this.bedrockKnowledgeStoreConfiguration(model.bedrockKnowledgeStoreConfiguration);
        }

        public final OpensearchConfiguration.Builder getOpensearchConfiguration() {
            return this.opensearchConfiguration != null ? this.opensearchConfiguration.toBuilder() : null;
        }

        public final void setOpensearchConfiguration(OpensearchConfiguration.BuilderImpl opensearchConfiguration) {
            this.opensearchConfiguration = opensearchConfiguration != null ? opensearchConfiguration.build() : null;
        }

        @Override
        public final Builder opensearchConfiguration(OpensearchConfiguration opensearchConfiguration) {
            this.opensearchConfiguration = opensearchConfiguration;
            return this;
        }

        public final QnAKendraConfiguration.Builder getKendraConfiguration() {
            return this.kendraConfiguration != null ? this.kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(QnAKendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(QnAKendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final BedrockKnowledgeStoreConfiguration.Builder getBedrockKnowledgeStoreConfiguration() {
            return this.bedrockKnowledgeStoreConfiguration != null ? this.bedrockKnowledgeStoreConfiguration.toBuilder() : null;
        }

        public final void setBedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration.BuilderImpl bedrockKnowledgeStoreConfiguration) {
            this.bedrockKnowledgeStoreConfiguration = bedrockKnowledgeStoreConfiguration != null ? bedrockKnowledgeStoreConfiguration.build() : null;
        }

        @Override
        public final Builder bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration) {
            this.bedrockKnowledgeStoreConfiguration = bedrockKnowledgeStoreConfiguration;
            return this;
        }

        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfiguration> {
        public Builder opensearchConfiguration(OpensearchConfiguration var1);

        default public Builder opensearchConfiguration(Consumer<OpensearchConfiguration.Builder> opensearchConfiguration) {
            return this.opensearchConfiguration((OpensearchConfiguration)((OpensearchConfiguration.Builder)OpensearchConfiguration.builder().applyMutation(opensearchConfiguration)).build());
        }

        public Builder kendraConfiguration(QnAKendraConfiguration var1);

        default public Builder kendraConfiguration(Consumer<QnAKendraConfiguration.Builder> kendraConfiguration) {
            return this.kendraConfiguration((QnAKendraConfiguration)((QnAKendraConfiguration.Builder)QnAKendraConfiguration.builder().applyMutation(kendraConfiguration)).build());
        }

        public Builder bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration var1);

        default public Builder bedrockKnowledgeStoreConfiguration(Consumer<BedrockKnowledgeStoreConfiguration.Builder> bedrockKnowledgeStoreConfiguration) {
            return this.bedrockKnowledgeStoreConfiguration((BedrockKnowledgeStoreConfiguration)((BedrockKnowledgeStoreConfiguration.Builder)BedrockKnowledgeStoreConfiguration.builder().applyMutation(bedrockKnowledgeStoreConfiguration)).build());
        }
    }
}

