/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleDetails;
import software.amazon.awssdk.services.lexmodelsv2.model.BotVersionLocaleSpecificationCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBotVersionRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, CreateBotVersionRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(CreateBotVersionRequest.getter(CreateBotVersionRequest::botId)).setter(CreateBotVersionRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateBotVersionRequest.getter(CreateBotVersionRequest::description)).setter(CreateBotVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, BotVersionLocaleDetails>> BOT_VERSION_LOCALE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("botVersionLocaleSpecification").getter(CreateBotVersionRequest.getter(CreateBotVersionRequest::botVersionLocaleSpecification)).setter(CreateBotVersionRequest.setter(Builder::botVersionLocaleSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionLocaleSpecification").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotVersionLocaleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, DESCRIPTION_FIELD, BOT_VERSION_LOCALE_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBotVersionRequest.memberNameToFieldInitializer();
    private final String botId;
    private final String description;
    private final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification;

    private CreateBotVersionRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.description = builder.description;
        this.botVersionLocaleSpecification = builder.botVersionLocaleSpecification;
    }

    public final String botId() {
        return this.botId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasBotVersionLocaleSpecification() {
        return this.botVersionLocaleSpecification != null && !(this.botVersionLocaleSpecification instanceof SdkAutoConstructMap);
    }

    public final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification() {
        return this.botVersionLocaleSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotVersionLocaleSpecification() ? this.botVersionLocaleSpecification() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotVersionRequest)) {
            return false;
        }
        CreateBotVersionRequest other = (CreateBotVersionRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.description(), other.description()) && this.hasBotVersionLocaleSpecification() == other.hasBotVersionLocaleSpecification() && Objects.equals(this.botVersionLocaleSpecification(), other.botVersionLocaleSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBotVersionRequest").add("BotId", (Object)this.botId()).add("Description", (Object)this.description()).add("BotVersionLocaleSpecification", this.hasBotVersionLocaleSpecification() ? this.botVersionLocaleSpecification() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "botVersionLocaleSpecification": {
                return Optional.ofNullable(clazz.cast(this.botVersionLocaleSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botVersionLocaleSpecification", BOT_VERSION_LOCALE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotVersionRequest, T> g) {
        return obj -> g.apply((CreateBotVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String description;
        private Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotVersionRequest model) {
            super(model);
            this.botId(model.botId);
            this.description(model.description);
            this.botVersionLocaleSpecification(model.botVersionLocaleSpecification);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, BotVersionLocaleDetails.Builder> getBotVersionLocaleSpecification() {
            Map<String, BotVersionLocaleDetails.Builder> result = BotVersionLocaleSpecificationCopier.copyToBuilder(this.botVersionLocaleSpecification);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotVersionLocaleSpecification(Map<String, BotVersionLocaleDetails.BuilderImpl> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier.copyFromBuilder(botVersionLocaleSpecification);
        }

        @Override
        public final Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier.copy(botVersionLocaleSpecification);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotVersionRequest build() {
            return new CreateBotVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBotVersionRequest> {
        public Builder botId(String var1);

        public Builder description(String var1);

        public Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

