/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.SlotSortBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSlotsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListSlotsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListSlotsRequest.getter(ListSlotsRequest::botId)).setter(ListSlotsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListSlotsRequest.getter(ListSlotsRequest::botVersion)).setter(ListSlotsRequest.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListSlotsRequest.getter(ListSlotsRequest::localeId)).setter(ListSlotsRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentId").getter(ListSlotsRequest.getter(ListSlotsRequest::intentId)).setter(ListSlotsRequest.setter(Builder::intentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("intentId").build()}).build();
    private static final SdkField<SlotSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListSlotsRequest.getter(ListSlotsRequest::sortBy)).setter(ListSlotsRequest.setter(Builder::sortBy)).constructor(SlotSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<List<SlotFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListSlotsRequest.getter(ListSlotsRequest::filters)).setter(ListSlotsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlotFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSlotsRequest.getter(ListSlotsRequest::maxResults)).setter(ListSlotsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSlotsRequest.getter(ListSlotsRequest::nextToken)).setter(ListSlotsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, INTENT_ID_FIELD, SORT_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSlotsRequest.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String intentId;
    private final SlotSortBy sortBy;
    private final List<SlotFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListSlotsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.intentId = builder.intentId;
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String intentId() {
        return this.intentId;
    }

    public final SlotSortBy sortBy() {
        return this.sortBy;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<SlotFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlotsRequest)) {
            return false;
        }
        ListSlotsRequest other = (ListSlotsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.intentId(), other.intentId()) && Objects.equals(this.sortBy(), other.sortBy()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSlotsRequest").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("IntentId", (Object)this.intentId()).add("SortBy", (Object)this.sortBy()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "intentId": {
                return Optional.ofNullable(clazz.cast(this.intentId()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("intentId", INTENT_ID_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSlotsRequest, T> g) {
        return obj -> g.apply((ListSlotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String intentId;
        private SlotSortBy sortBy;
        private List<SlotFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlotsRequest model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.intentId(model.intentId);
            this.sortBy(model.sortBy);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getIntentId() {
            return this.intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final SlotSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(SlotSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SlotSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<SlotFilter.Builder> getFilters() {
            List<SlotFilter.Builder> result = SlotFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<SlotFilter.BuilderImpl> filters) {
            this.filters = SlotFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<SlotFilter> filters) {
            this.filters = SlotFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(SlotFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<SlotFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (SlotFilter)((SlotFilter.Builder)SlotFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSlotsRequest build() {
            return new ListSlotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSlotsRequest> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder intentId(String var1);

        public Builder sortBy(SlotSortBy var1);

        default public Builder sortBy(Consumer<SlotSortBy.Builder> sortBy) {
            return this.sortBy((SlotSortBy)((SlotSortBy.Builder)SlotSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder filters(Collection<SlotFilter> var1);

        public Builder filters(SlotFilter ... var1);

        public Builder filters(Consumer<SlotFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

