/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotsResponse;

public class ListBotsIterable
implements SdkIterable<ListBotsResponse> {
    private final LexModelsV2Client client;
    private final ListBotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBotsIterable(LexModelsV2Client client, ListBotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBotsResponseFetcher();
    }

    public Iterator<ListBotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBotsResponseFetcher
    implements SyncPageFetcher<ListBotsResponse> {
        private ListBotsResponseFetcher() {
        }

        public boolean hasNextPage(ListBotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBotsResponse nextPage(ListBotsResponse previousPage) {
            if (previousPage == null) {
                return ListBotsIterable.this.client.listBots(ListBotsIterable.this.firstRequest);
            }
            return ListBotsIterable.this.client.listBots((ListBotsRequest)((Object)ListBotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

