/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.SampleValue;
import software.amazon.awssdk.services.lexmodelsv2.model.SynonymListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlotTypeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlotTypeValue> {
    private static final SdkField<SampleValue> SAMPLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sampleValue").getter(SlotTypeValue.getter(SlotTypeValue::sampleValue)).setter(SlotTypeValue.setter(Builder::sampleValue)).constructor(SampleValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleValue").build()}).build();
    private static final SdkField<List<SampleValue>> SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("synonyms").getter(SlotTypeValue.getter(SlotTypeValue::synonyms)).setter(SlotTypeValue.setter(Builder::synonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SampleValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAMPLE_VALUE_FIELD, SYNONYMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final SampleValue sampleValue;
    private final List<SampleValue> synonyms;

    private SlotTypeValue(BuilderImpl builder) {
        this.sampleValue = builder.sampleValue;
        this.synonyms = builder.synonyms;
    }

    public final SampleValue sampleValue() {
        return this.sampleValue;
    }

    public final boolean hasSynonyms() {
        return this.synonyms != null && !(this.synonyms instanceof SdkAutoConstructList);
    }

    public final List<SampleValue> synonyms() {
        return this.synonyms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSynonyms() ? this.synonyms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotTypeValue)) {
            return false;
        }
        SlotTypeValue other = (SlotTypeValue)obj;
        return Objects.equals(this.sampleValue(), other.sampleValue()) && this.hasSynonyms() == other.hasSynonyms() && Objects.equals(this.synonyms(), other.synonyms());
    }

    public final String toString() {
        return ToString.builder((String)"SlotTypeValue").add("SampleValue", (Object)this.sampleValue()).add("Synonyms", this.hasSynonyms() ? this.synonyms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sampleValue": {
                return Optional.ofNullable(clazz.cast(this.sampleValue()));
            }
            case "synonyms": {
                return Optional.ofNullable(clazz.cast(this.synonyms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SlotTypeValue, T> g) {
        return obj -> g.apply((SlotTypeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SampleValue sampleValue;
        private List<SampleValue> synonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SlotTypeValue model) {
            this.sampleValue(model.sampleValue);
            this.synonyms(model.synonyms);
        }

        public final SampleValue.Builder getSampleValue() {
            return this.sampleValue != null ? this.sampleValue.toBuilder() : null;
        }

        public final void setSampleValue(SampleValue.BuilderImpl sampleValue) {
            this.sampleValue = sampleValue != null ? sampleValue.build() : null;
        }

        @Override
        @Transient
        public final Builder sampleValue(SampleValue sampleValue) {
            this.sampleValue = sampleValue;
            return this;
        }

        public final List<SampleValue.Builder> getSynonyms() {
            List<SampleValue.Builder> result = SynonymListCopier.copyToBuilder(this.synonyms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSynonyms(Collection<SampleValue.BuilderImpl> synonyms) {
            this.synonyms = SynonymListCopier.copyFromBuilder(synonyms);
        }

        @Override
        @Transient
        public final Builder synonyms(Collection<SampleValue> synonyms) {
            this.synonyms = SynonymListCopier.copy(synonyms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder synonyms(SampleValue ... synonyms) {
            this.synonyms(Arrays.asList(synonyms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder synonyms(Consumer<SampleValue.Builder> ... synonyms) {
            this.synonyms(Stream.of(synonyms).map(c -> (SampleValue)((SampleValue.Builder)SampleValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SlotTypeValue build() {
            return new SlotTypeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlotTypeValue> {
        public Builder sampleValue(SampleValue var1);

        default public Builder sampleValue(Consumer<SampleValue.Builder> sampleValue) {
            return this.sampleValue((SampleValue)((SampleValue.Builder)SampleValue.builder().applyMutation(sampleValue)).build());
        }

        public Builder synonyms(Collection<SampleValue> var1);

        public Builder synonyms(SampleValue ... var1);

        public Builder synonyms(Consumer<SampleValue.Builder> ... var1);
    }
}

