/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SlotTypeCategory {
    CUSTOM("Custom"),
    EXTENDED("Extended"),
    EXTERNAL_GRAMMAR("ExternalGrammar"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SlotTypeCategory> VALUE_MAP;
    private final String value;

    private SlotTypeCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlotTypeCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlotTypeCategory> knownValues() {
        EnumSet<SlotTypeCategory> knownValues = EnumSet.allOf(SlotTypeCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SlotTypeCategory.class, SlotTypeCategory::toString);
    }
}

