/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.RecommendedIntentSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendedIntentsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListRecommendedIntentsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::botId)).setter(ListRecommendedIntentsResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::botVersion)).setter(ListRecommendedIntentsResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::localeId)).setter(ListRecommendedIntentsResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> BOT_RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botRecommendationId").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::botRecommendationId)).setter(ListRecommendedIntentsResponse.setter(Builder::botRecommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationId").build()}).build();
    private static final SdkField<List<RecommendedIntentSummary>> SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaryList").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::summaryList)).setter(ListRecommendedIntentsResponse.setter(Builder::summaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedIntentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendedIntentsResponse.getter(ListRecommendedIntentsResponse::nextToken)).setter(ListRecommendedIntentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_ID_FIELD, SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String botRecommendationId;
    private final List<RecommendedIntentSummary> summaryList;
    private final String nextToken;

    private ListRecommendedIntentsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationId = builder.botRecommendationId;
        this.summaryList = builder.summaryList;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String botRecommendationId() {
        return this.botRecommendationId;
    }

    public final boolean hasSummaryList() {
        return this.summaryList != null && !(this.summaryList instanceof SdkAutoConstructList);
    }

    public final List<RecommendedIntentSummary> summaryList() {
        return this.summaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botRecommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryList() ? this.summaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendedIntentsResponse)) {
            return false;
        }
        ListRecommendedIntentsResponse other = (ListRecommendedIntentsResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.botRecommendationId(), other.botRecommendationId()) && this.hasSummaryList() == other.hasSummaryList() && Objects.equals(this.summaryList(), other.summaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendedIntentsResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("BotRecommendationId", (Object)this.botRecommendationId()).add("SummaryList", this.hasSummaryList() ? this.summaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "botRecommendationId": {
                return Optional.ofNullable(clazz.cast(this.botRecommendationId()));
            }
            case "summaryList": {
                return Optional.ofNullable(clazz.cast(this.summaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendedIntentsResponse, T> g) {
        return obj -> g.apply((ListRecommendedIntentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String botRecommendationId;
        private List<RecommendedIntentSummary> summaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendedIntentsResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.botRecommendationId(model.botRecommendationId);
            this.summaryList(model.summaryList);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        @Transient
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        @Transient
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        @Transient
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotRecommendationId() {
            return this.botRecommendationId;
        }

        public final void setBotRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
        }

        @Override
        @Transient
        public final Builder botRecommendationId(String botRecommendationId) {
            this.botRecommendationId = botRecommendationId;
            return this;
        }

        public final List<RecommendedIntentSummary.Builder> getSummaryList() {
            List<RecommendedIntentSummary.Builder> result = RecommendedIntentSummaryListCopier.copyToBuilder(this.summaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryList(Collection<RecommendedIntentSummary.BuilderImpl> summaryList) {
            this.summaryList = RecommendedIntentSummaryListCopier.copyFromBuilder(summaryList);
        }

        @Override
        @Transient
        public final Builder summaryList(Collection<RecommendedIntentSummary> summaryList) {
            this.summaryList = RecommendedIntentSummaryListCopier.copy(summaryList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaryList(RecommendedIntentSummary ... summaryList) {
            this.summaryList(Arrays.asList(summaryList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder summaryList(Consumer<RecommendedIntentSummary.Builder> ... summaryList) {
            this.summaryList(Stream.of(summaryList).map(c -> (RecommendedIntentSummary)((RecommendedIntentSummary.Builder)RecommendedIntentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendedIntentsResponse build() {
            return new ListRecommendedIntentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendedIntentsResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder botRecommendationId(String var1);

        public Builder summaryList(Collection<RecommendedIntentSummary> var1);

        public Builder summaryList(RecommendedIntentSummary ... var1);

        public Builder summaryList(Consumer<RecommendedIntentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

