/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ExportStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteExportResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DeleteExportResponse> {
    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportId").getter(DeleteExportResponse.getter(DeleteExportResponse::exportId)).setter(DeleteExportResponse.setter(Builder::exportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportId").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exportStatus").getter(DeleteExportResponse.getter(DeleteExportResponse::exportStatusAsString)).setter(DeleteExportResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_ID_FIELD, EXPORT_STATUS_FIELD));
    private final String exportId;
    private final String exportStatus;

    private DeleteExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportId = builder.exportId;
        this.exportStatus = builder.exportStatus;
    }

    public final String exportId() {
        return this.exportId;
    }

    public final ExportStatus exportStatus() {
        return ExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExportResponse)) {
            return false;
        }
        DeleteExportResponse other = (DeleteExportResponse)((Object)obj);
        return Objects.equals(this.exportId(), other.exportId()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteExportResponse").add("ExportId", (Object)this.exportId()).add("ExportStatus", (Object)this.exportStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportId": {
                return Optional.ofNullable(clazz.cast(this.exportId()));
            }
            case "exportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteExportResponse, T> g) {
        return obj -> g.apply((DeleteExportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String exportId;
        private String exportStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExportResponse model) {
            super(model);
            this.exportId(model.exportId);
            this.exportStatus(model.exportStatus);
        }

        public final String getExportId() {
            return this.exportId;
        }

        public final void setExportId(String exportId) {
            this.exportId = exportId;
        }

        @Override
        @Transient
        public final Builder exportId(String exportId) {
            this.exportId = exportId;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        @Transient
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder exportStatus(ExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        @Override
        public DeleteExportResponse build() {
            return new DeleteExportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteExportResponse> {
        public Builder exportId(String var1);

        public Builder exportStatus(String var1);

        public Builder exportStatus(ExportStatus var1);
    }
}

