/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotAliasResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotLocaleResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeBotVersionResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeExportResponse;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.DescribeImportResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface LexModelsV2AsyncWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotAlias} API until the desired condition {@code BotAliasAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotAliasRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(
            DescribeBotAliasRequest describeBotAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotAlias} API until the desired condition {@code BotAliasAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotAliasRequest#builder()}
     *
     * @param describeBotAliasRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(
            Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest) {
        return waitUntilBotAliasAvailable(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotAlias} API until the desired condition {@code BotAliasAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotAliasRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(
            DescribeBotAliasRequest describeBotAliasRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotAlias} API until the desired condition {@code BotAliasAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotAliasRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotAliasResponse>> waitUntilBotAliasAvailable(
            Consumer<DescribeBotAliasRequest.Builder> describeBotAliasRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotAliasAvailable(DescribeBotAliasRequest.builder().applyMutation(describeBotAliasRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBot} API until the desired condition {@code BotAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(DescribeBotRequest describeBotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBot} API until the desired condition {@code BotAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotRequest#builder()}
     *
     * @param describeBotRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(
            Consumer<DescribeBotRequest.Builder> describeBotRequest) {
        return waitUntilBotAvailable(DescribeBotRequest.builder().applyMutation(describeBotRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBot} API until the desired condition {@code BotAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(DescribeBotRequest describeBotRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBot} API until the desired condition {@code BotAvailable} is met, or
     * until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotResponse>> waitUntilBotAvailable(
            Consumer<DescribeBotRequest.Builder> describeBotRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotAvailable(DescribeBotRequest.builder().applyMutation(describeBotRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeExport} API until the desired condition {@code BotExportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(
            DescribeExportRequest describeExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeExport} API until the desired condition {@code BotExportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeExportRequest#builder()}
     *
     * @param describeExportRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(
            Consumer<DescribeExportRequest.Builder> describeExportRequest) {
        return waitUntilBotExportCompleted(DescribeExportRequest.builder().applyMutation(describeExportRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeExport} API until the desired condition {@code BotExportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeExportRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(
            DescribeExportRequest describeExportRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeExport} API until the desired condition {@code BotExportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeExportRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeExportResponse>> waitUntilBotExportCompleted(
            Consumer<DescribeExportRequest.Builder> describeExportRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotExportCompleted(DescribeExportRequest.builder().applyMutation(describeExportRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeImport} API until the desired condition {@code BotImportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeImportRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(
            DescribeImportRequest describeImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeImport} API until the desired condition {@code BotImportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeImportRequest#builder()}
     *
     * @param describeImportRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(
            Consumer<DescribeImportRequest.Builder> describeImportRequest) {
        return waitUntilBotImportCompleted(DescribeImportRequest.builder().applyMutation(describeImportRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeImport} API until the desired condition {@code BotImportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeImportRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(
            DescribeImportRequest describeImportRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeImport} API until the desired condition {@code BotImportCompleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeImportRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeImportResponse>> waitUntilBotImportCompleted(
            Consumer<DescribeImportRequest.Builder> describeImportRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotImportCompleted(DescribeImportRequest.builder().applyMutation(describeImportRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleBuilt} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotLocaleRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(
            DescribeBotLocaleRequest describeBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleBuilt} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotLocaleRequest#builder()}
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest) {
        return waitUntilBotLocaleBuilt(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleBuilt} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotLocaleRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(
            DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleBuilt} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleBuilt(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotLocaleBuilt(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleCreated}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotLocaleRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(
            DescribeBotLocaleRequest describeBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleCreated}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotLocaleRequest#builder()}
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest) {
        return waitUntilBotLocaleCreated(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleCreated}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeBotLocaleRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(
            DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition {@code BotLocaleCreated}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleCreated(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotLocaleCreated(DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition
     * {@code BotLocaleExpressTestingAvailable} is met, or until it is determined that the resource will never enter
     * into the desired state
     *
     * @param describeBotLocaleRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(
            DescribeBotLocaleRequest describeBotLocaleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition
     * {@code BotLocaleExpressTestingAvailable} is met, or until it is determined that the resource will never enter
     * into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotLocaleRequest#builder()}
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest) {
        return waitUntilBotLocaleExpressTestingAvailable(DescribeBotLocaleRequest.builder()
                .applyMutation(describeBotLocaleRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition
     * {@code BotLocaleExpressTestingAvailable} is met, or until it is determined that the resource will never enter
     * into the desired state
     *
     * @param describeBotLocaleRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(
            DescribeBotLocaleRequest describeBotLocaleRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotLocale} API until the desired condition
     * {@code BotLocaleExpressTestingAvailable} is met, or until it is determined that the resource will never enter
     * into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotLocaleRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotLocaleResponse>> waitUntilBotLocaleExpressTestingAvailable(
            Consumer<DescribeBotLocaleRequest.Builder> describeBotLocaleRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotLocaleExpressTestingAvailable(
                DescribeBotLocaleRequest.builder().applyMutation(describeBotLocaleRequest).build(), WaiterOverrideConfiguration
                        .builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotVersion} API until the desired condition
     * {@code BotVersionAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeBotVersionRequest
     *        the request to be used for polling
     * @return CompletableFuture containing the WaiterResponse. It completes successfully when the resource enters into
     *         a desired state or exceptionally when it is determined that the resource will never enter into the
     *         desired state.
     */
    default CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(
            DescribeBotVersionRequest describeBotVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotVersion} API until the desired condition
     * {@code BotVersionAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBotVersionRequest#builder()}
     *
     * @param describeBotVersionRequest
     *        The consumer that will configure the request to be used for polling
     * @return CompletableFuture of the WaiterResponse containing either a response or an exception that has matched
     *         with the waiter success condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(
            Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest) {
        return waitUntilBotVersionAvailable(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build());
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotVersion} API until the desired condition
     * {@code BotVersionAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeBotVersionRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(
            DescribeBotVersionRequest describeBotVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link LexModelsV2AsyncClient#describeBotVersion} API until the desired condition
     * {@code BotVersionAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBotVersionRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default CompletableFuture<WaiterResponse<DescribeBotVersionResponse>> waitUntilBotVersionAvailable(
            Consumer<DescribeBotVersionRequest.Builder> describeBotVersionRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBotVersionAvailable(DescribeBotVersionRequest.builder().applyMutation(describeBotVersionRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link LexModelsV2AsyncWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultLexModelsV2AsyncWaiter.builder();
    }

    /**
     * Create an instance of {@link LexModelsV2AsyncWaiter} with the default configuration.
     * <p>
     * <b>A default {@link LexModelsV2AsyncClient} will be created to poll resources. It is recommended to share a
     * single instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link LexModelsV2AsyncWaiter}
     */
    static LexModelsV2AsyncWaiter create() {
        return DefaultLexModelsV2AsyncWaiter.builder().build();
    }

    interface Builder {
        /**
         * Sets a custom {@link ScheduledExecutorService} that will be used to schedule async polling attempts
         * <p>
         * This executorService must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * executorService when the waiter is closed
         *
         * @param executorService
         *        the executorService to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder scheduledExecutorService(ScheduledExecutorService executorService);

        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link LexModelsV2AsyncClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(LexModelsV2AsyncClient client);

        /**
         * Builds an instance of {@link LexModelsV2AsyncWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link LexModelsV2AsyncWaiter}
         */
        LexModelsV2AsyncWaiter build();
    }
}
