/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the prompts that Amazon Lex uses while a bot is waiting for customer input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WaitAndContinueSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<WaitAndContinueSpecification.Builder, WaitAndContinueSpecification> {
    private static final SdkField<ResponseSpecification> WAITING_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("waitingResponse")
            .getter(getter(WaitAndContinueSpecification::waitingResponse)).setter(setter(Builder::waitingResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitingResponse").build()).build();

    private static final SdkField<ResponseSpecification> CONTINUE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("continueResponse")
            .getter(getter(WaitAndContinueSpecification::continueResponse)).setter(setter(Builder::continueResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continueResponse").build()).build();

    private static final SdkField<StillWaitingResponseSpecification> STILL_WAITING_RESPONSE_FIELD = SdkField
            .<StillWaitingResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("stillWaitingResponse")
            .getter(getter(WaitAndContinueSpecification::stillWaitingResponse)).setter(setter(Builder::stillWaitingResponse))
            .constructor(StillWaitingResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stillWaitingResponse").build())
            .build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("active").getter(getter(WaitAndContinueSpecification::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAITING_RESPONSE_FIELD,
            CONTINUE_RESPONSE_FIELD, STILL_WAITING_RESPONSE_FIELD, ACTIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification waitingResponse;

    private final ResponseSpecification continueResponse;

    private final StillWaitingResponseSpecification stillWaitingResponse;

    private final Boolean active;

    private WaitAndContinueSpecification(BuilderImpl builder) {
        this.waitingResponse = builder.waitingResponse;
        this.continueResponse = builder.continueResponse;
        this.stillWaitingResponse = builder.stillWaitingResponse;
        this.active = builder.active;
    }

    /**
     * <p>
     * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
     * </p>
     * 
     * @return The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
     */
    public final ResponseSpecification waitingResponse() {
        return waitingResponse;
    }

    /**
     * <p>
     * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
     * </p>
     * 
     * @return The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
     */
    public final ResponseSpecification continueResponse() {
        return continueResponse;
    }

    /**
     * <p>
     * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input
     * from the user.
     * </p>
     * 
     * @return A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for
     *         input from the user.
     */
    public final StillWaitingResponseSpecification stillWaitingResponse() {
        return stillWaitingResponse;
    }

    /**
     * <p>
     * Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue responses
     * for a slot aren't used. If the <code>active</code> field isn't specified, the default is true.
     * </p>
     * 
     * @return Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue
     *         responses for a slot aren't used. If the <code>active</code> field isn't specified, the default is true.
     */
    public final Boolean active() {
        return active;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(waitingResponse());
        hashCode = 31 * hashCode + Objects.hashCode(continueResponse());
        hashCode = 31 * hashCode + Objects.hashCode(stillWaitingResponse());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaitAndContinueSpecification)) {
            return false;
        }
        WaitAndContinueSpecification other = (WaitAndContinueSpecification) obj;
        return Objects.equals(waitingResponse(), other.waitingResponse())
                && Objects.equals(continueResponse(), other.continueResponse())
                && Objects.equals(stillWaitingResponse(), other.stillWaitingResponse())
                && Objects.equals(active(), other.active());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WaitAndContinueSpecification").add("WaitingResponse", waitingResponse())
                .add("ContinueResponse", continueResponse()).add("StillWaitingResponse", stillWaitingResponse())
                .add("Active", active()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "waitingResponse":
            return Optional.ofNullable(clazz.cast(waitingResponse()));
        case "continueResponse":
            return Optional.ofNullable(clazz.cast(continueResponse()));
        case "stillWaitingResponse":
            return Optional.ofNullable(clazz.cast(stillWaitingResponse()));
        case "active":
            return Optional.ofNullable(clazz.cast(active()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WaitAndContinueSpecification, T> g) {
        return obj -> g.apply((WaitAndContinueSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WaitAndContinueSpecification> {
        /**
         * <p>
         * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
         * </p>
         * 
         * @param waitingResponse
         *        The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to
         *        continue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitingResponse(ResponseSpecification waitingResponse);

        /**
         * <p>
         * The response that Amazon Lex sends to indicate that the bot is waiting for the conversation to continue.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseSpecification.Builder} avoiding the need
         * to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #waitingResponse(ResponseSpecification)}.
         * 
         * @param waitingResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitingResponse(ResponseSpecification)
         */
        default Builder waitingResponse(Consumer<ResponseSpecification.Builder> waitingResponse) {
            return waitingResponse(ResponseSpecification.builder().applyMutation(waitingResponse).build());
        }

        /**
         * <p>
         * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
         * </p>
         * 
         * @param continueResponse
         *        The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueResponse(ResponseSpecification continueResponse);

        /**
         * <p>
         * The response that Amazon Lex sends to indicate that the bot is ready to continue the conversation.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseSpecification.Builder} avoiding the need
         * to create one manually via {@link ResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #continueResponse(ResponseSpecification)}.
         * 
         * @param continueResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continueResponse(ResponseSpecification)
         */
        default Builder continueResponse(Consumer<ResponseSpecification.Builder> continueResponse) {
            return continueResponse(ResponseSpecification.builder().applyMutation(continueResponse).build());
        }

        /**
         * <p>
         * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input
         * from the user.
         * </p>
         * 
         * @param stillWaitingResponse
         *        A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting
         *        for input from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stillWaitingResponse(StillWaitingResponseSpecification stillWaitingResponse);

        /**
         * <p>
         * A response that Amazon Lex sends periodically to the user to indicate that the bot is still waiting for input
         * from the user.
         * </p>
         * This is a convenience that creates an instance of the {@link StillWaitingResponseSpecification.Builder}
         * avoiding the need to create one manually via {@link StillWaitingResponseSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link StillWaitingResponseSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #stillWaitingResponse(StillWaitingResponseSpecification)}.
         * 
         * @param stillWaitingResponse
         *        a consumer that will call methods on {@link StillWaitingResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stillWaitingResponse(StillWaitingResponseSpecification)
         */
        default Builder stillWaitingResponse(Consumer<StillWaitingResponseSpecification.Builder> stillWaitingResponse) {
            return stillWaitingResponse(StillWaitingResponseSpecification.builder().applyMutation(stillWaitingResponse).build());
        }

        /**
         * <p>
         * Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue
         * responses for a slot aren't used. If the <code>active</code> field isn't specified, the default is true.
         * </p>
         * 
         * @param active
         *        Specifies whether the bot will wait for a user to respond. When this field is false, wait and continue
         *        responses for a slot aren't used. If the <code>active</code> field isn't specified, the default is
         *        true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification waitingResponse;

        private ResponseSpecification continueResponse;

        private StillWaitingResponseSpecification stillWaitingResponse;

        private Boolean active;

        private BuilderImpl() {
        }

        private BuilderImpl(WaitAndContinueSpecification model) {
            waitingResponse(model.waitingResponse);
            continueResponse(model.continueResponse);
            stillWaitingResponse(model.stillWaitingResponse);
            active(model.active);
        }

        public final ResponseSpecification.Builder getWaitingResponse() {
            return waitingResponse != null ? waitingResponse.toBuilder() : null;
        }

        public final void setWaitingResponse(ResponseSpecification.BuilderImpl waitingResponse) {
            this.waitingResponse = waitingResponse != null ? waitingResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder waitingResponse(ResponseSpecification waitingResponse) {
            this.waitingResponse = waitingResponse;
            return this;
        }

        public final ResponseSpecification.Builder getContinueResponse() {
            return continueResponse != null ? continueResponse.toBuilder() : null;
        }

        public final void setContinueResponse(ResponseSpecification.BuilderImpl continueResponse) {
            this.continueResponse = continueResponse != null ? continueResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder continueResponse(ResponseSpecification continueResponse) {
            this.continueResponse = continueResponse;
            return this;
        }

        public final StillWaitingResponseSpecification.Builder getStillWaitingResponse() {
            return stillWaitingResponse != null ? stillWaitingResponse.toBuilder() : null;
        }

        public final void setStillWaitingResponse(StillWaitingResponseSpecification.BuilderImpl stillWaitingResponse) {
            this.stillWaitingResponse = stillWaitingResponse != null ? stillWaitingResponse.build() : null;
        }

        @Override
        @Transient
        public final Builder stillWaitingResponse(StillWaitingResponseSpecification stillWaitingResponse) {
            this.stillWaitingResponse = stillWaitingResponse;
            return this;
        }

        public final Boolean getActive() {
            return active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        @Transient
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        @Override
        public WaitAndContinueSpecification build() {
            return new WaitAndContinueSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
