/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides parameters for setting the time window and duration for aggregating utterance data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceAggregationDuration implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceAggregationDuration.Builder, UtteranceAggregationDuration> {
    private static final SdkField<RelativeAggregationDuration> RELATIVE_AGGREGATION_DURATION_FIELD = SdkField
            .<RelativeAggregationDuration> builder(MarshallingType.SDK_POJO)
            .memberName("relativeAggregationDuration")
            .getter(getter(UtteranceAggregationDuration::relativeAggregationDuration))
            .setter(setter(Builder::relativeAggregationDuration))
            .constructor(RelativeAggregationDuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativeAggregationDuration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RELATIVE_AGGREGATION_DURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final RelativeAggregationDuration relativeAggregationDuration;

    private UtteranceAggregationDuration(BuilderImpl builder) {
        this.relativeAggregationDuration = builder.relativeAggregationDuration;
    }

    /**
     * <p>
     * The desired time window for aggregating utterances.
     * </p>
     * 
     * @return The desired time window for aggregating utterances.
     */
    public final RelativeAggregationDuration relativeAggregationDuration() {
        return relativeAggregationDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relativeAggregationDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceAggregationDuration)) {
            return false;
        }
        UtteranceAggregationDuration other = (UtteranceAggregationDuration) obj;
        return Objects.equals(relativeAggregationDuration(), other.relativeAggregationDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceAggregationDuration").add("RelativeAggregationDuration", relativeAggregationDuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relativeAggregationDuration":
            return Optional.ofNullable(clazz.cast(relativeAggregationDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceAggregationDuration, T> g) {
        return obj -> g.apply((UtteranceAggregationDuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceAggregationDuration> {
        /**
         * <p>
         * The desired time window for aggregating utterances.
         * </p>
         * 
         * @param relativeAggregationDuration
         *        The desired time window for aggregating utterances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relativeAggregationDuration(RelativeAggregationDuration relativeAggregationDuration);

        /**
         * <p>
         * The desired time window for aggregating utterances.
         * </p>
         * This is a convenience that creates an instance of the {@link RelativeAggregationDuration.Builder} avoiding
         * the need to create one manually via {@link RelativeAggregationDuration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RelativeAggregationDuration.Builder#build()} is called
         * immediately and its result is passed to {@link #relativeAggregationDuration(RelativeAggregationDuration)}.
         * 
         * @param relativeAggregationDuration
         *        a consumer that will call methods on {@link RelativeAggregationDuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relativeAggregationDuration(RelativeAggregationDuration)
         */
        default Builder relativeAggregationDuration(Consumer<RelativeAggregationDuration.Builder> relativeAggregationDuration) {
            return relativeAggregationDuration(RelativeAggregationDuration.builder().applyMutation(relativeAggregationDuration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RelativeAggregationDuration relativeAggregationDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceAggregationDuration model) {
            relativeAggregationDuration(model.relativeAggregationDuration);
        }

        public final RelativeAggregationDuration.Builder getRelativeAggregationDuration() {
            return relativeAggregationDuration != null ? relativeAggregationDuration.toBuilder() : null;
        }

        public final void setRelativeAggregationDuration(RelativeAggregationDuration.BuilderImpl relativeAggregationDuration) {
            this.relativeAggregationDuration = relativeAggregationDuration != null ? relativeAggregationDuration.build() : null;
        }

        @Override
        @Transient
        public final Builder relativeAggregationDuration(RelativeAggregationDuration relativeAggregationDuration) {
            this.relativeAggregationDuration = relativeAggregationDuration;
            return this;
        }

        @Override
        public UtteranceAggregationDuration build() {
            return new UtteranceAggregationDuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
