/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotsRequest extends LexModelsV2Request implements
        ToCopyableBuilder<ListBotsRequest.Builder, ListBotsRequest> {
    private static final SdkField<BotSortBy> SORT_BY_FIELD = SdkField.<BotSortBy> builder(MarshallingType.SDK_POJO)
            .memberName("sortBy").getter(getter(ListBotsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(BotSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<List<BotFilter>> FILTERS_FIELD = SdkField
            .<List<BotFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListBotsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListBotsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final BotSortBy sortBy;

    private final List<BotFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListBotsRequest(BuilderImpl builder) {
        super(builder);
        this.sortBy = builder.sortBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in
     * ascending or descending order.
     * </p>
     * 
     * @return Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in
     *         ascending or descending order.
     */
    public final BotSortBy sortBy() {
        return sortBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the specification of a filter used to limit the bots in the response to only those that match the filter
     * specification. You can only specify one filter and one string to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Provides the specification of a filter used to limit the bots in the response to only those that match
     *         the filter specification. You can only specify one filter and one string to filter on.
     */
    public final List<BotFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of bots to return in each page of results. If there are fewer results than the maximum page
     * size, only the actual number of results are returned.
     * </p>
     * 
     * @return The maximum number of bots to return in each page of results. If there are fewer results than the maximum
     *         page size, only the actual number of results are returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the response from the <code>ListBots</code> operation contains more results than specified in the
     * <code>maxResults</code> parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return the
     * next page of results. For a complete set of results, call the <code>ListBots</code> operation until the
     * <code>nextToken</code> returned in the response is null.
     * </p>
     * 
     * @return If the response from the <code>ListBots</code> operation contains more results than specified in the
     *         <code>maxResults</code> parameter, a token is returned in the response. </p>
     *         <p>
     *         Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to
     *         return the next page of results. For a complete set of results, call the <code>ListBots</code> operation
     *         until the <code>nextToken</code> returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotsRequest)) {
            return false;
        }
        ListBotsRequest other = (ListBotsRequest) obj;
        return Objects.equals(sortBy(), other.sortBy()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotsRequest").add("SortBy", sortBy()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBotsRequest, T> g) {
        return obj -> g.apply((ListBotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListBotsRequest> {
        /**
         * <p>
         * Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in
         * ascending or descending order.
         * </p>
         * 
         * @param sortBy
         *        Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name
         *        in ascending or descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(BotSortBy sortBy);

        /**
         * <p>
         * Specifies sorting parameters for the list of bots. You can specify that the list be sorted by bot name in
         * ascending or descending order.
         * </p>
         * This is a convenience that creates an instance of the {@link BotSortBy.Builder} avoiding the need to create
         * one manually via {@link BotSortBy#builder()}.
         *
         * When the {@link Consumer} completes, {@link BotSortBy.Builder#build()} is called immediately and its result
         * is passed to {@link #sortBy(BotSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link BotSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(BotSortBy)
         */
        default Builder sortBy(Consumer<BotSortBy.Builder> sortBy) {
            return sortBy(BotSortBy.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the bots in the response to only those that match
         *        the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<BotFilter> filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * 
         * @param filters
         *        Provides the specification of a filter used to limit the bots in the response to only those that match
         *        the filter specification. You can only specify one filter and one string to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(BotFilter... filters);

        /**
         * <p>
         * Provides the specification of a filter used to limit the bots in the response to only those that match the
         * filter specification. You can only specify one filter and one string to filter on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BotFilter>.Builder} avoiding the need to
         * create one manually via {@link List<BotFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BotFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<BotFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<BotFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<BotFilter>)
         */
        Builder filters(Consumer<BotFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of bots to return in each page of results. If there are fewer results than the maximum
         * page size, only the actual number of results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of bots to return in each page of results. If there are fewer results than the
         *        maximum page size, only the actual number of results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the response from the <code>ListBots</code> operation contains more results than specified in the
         * <code>maxResults</code> parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to return
         * the next page of results. For a complete set of results, call the <code>ListBots</code> operation until the
         * <code>nextToken</code> returned in the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the <code>ListBots</code> operation contains more results than specified in the
         *        <code>maxResults</code> parameter, a token is returned in the response. </p>
         *        <p>
         *        Use the returned token in the <code>nextToken</code> parameter of a <code>ListBots</code> request to
         *        return the next page of results. For a complete set of results, call the <code>ListBots</code>
         *        operation until the <code>nextToken</code> returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private BotSortBy sortBy;

        private List<BotFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotsRequest model) {
            super(model);
            sortBy(model.sortBy);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final BotSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(BotSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        @Transient
        public final Builder sortBy(BotSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final List<BotFilter.Builder> getFilters() {
            List<BotFilter.Builder> result = BotFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<BotFilter.BuilderImpl> filters) {
            this.filters = BotFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<BotFilter> filters) {
            this.filters = BotFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(BotFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<BotFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> BotFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBotsRequest build() {
            return new ListBotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
