/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetIntentsResponse;

public class GetIntentsIterable
implements SdkIterable<GetIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIntentsIterable(LexModelBuildingClient client, GetIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIntentsResponseFetcher();
    }

    public Iterator<GetIntentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetIntentsResponseFetcher
    implements SyncPageFetcher<GetIntentsResponse> {
        private GetIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIntentsResponse nextPage(GetIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetIntentsIterable.this.client.getIntents(GetIntentsIterable.this.firstRequest);
            }
            return GetIntentsIterable.this.client.getIntents((GetIntentsRequest)((Object)GetIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

