/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentFilterKey {
    WORKLOAD_NAME("WORKLOAD_NAME"),
    DEPLOYMENT_STATUS("DEPLOYMENT_STATUS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentFilterKey> VALUE_MAP;
    private final String value;

    private DeploymentFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentFilterKey> knownValues() {
        EnumSet<DeploymentFilterKey> knownValues = EnumSet.allOf(DeploymentFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentFilterKey.class, DeploymentFilterKey::toString);
    }
}

