/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkloadDeploymentPatternDataSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkloadDeploymentPatternDataSummary> {
    private static final SdkField<String> DEPLOYMENT_PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentPatternName").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::deploymentPatternName)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::deploymentPatternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPatternName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::description)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::displayName)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::statusAsString)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::statusMessage)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadName").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::workloadName)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadName").build()}).build();
    private static final SdkField<String> WORKLOAD_VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadVersionName").getter(WorkloadDeploymentPatternDataSummary.getter(WorkloadDeploymentPatternDataSummary::workloadVersionName)).setter(WorkloadDeploymentPatternDataSummary.setter(Builder::workloadVersionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadVersionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_PATTERN_NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, WORKLOAD_NAME_FIELD, WORKLOAD_VERSION_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkloadDeploymentPatternDataSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deploymentPatternName;
    private final String description;
    private final String displayName;
    private final String status;
    private final String statusMessage;
    private final String workloadName;
    private final String workloadVersionName;

    private WorkloadDeploymentPatternDataSummary(BuilderImpl builder) {
        this.deploymentPatternName = builder.deploymentPatternName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.workloadName = builder.workloadName;
        this.workloadVersionName = builder.workloadVersionName;
    }

    public final String deploymentPatternName() {
        return this.deploymentPatternName;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final WorkloadDeploymentPatternStatus status() {
        return WorkloadDeploymentPatternStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String workloadVersionName() {
        return this.workloadVersionName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentPatternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadVersionName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkloadDeploymentPatternDataSummary)) {
            return false;
        }
        WorkloadDeploymentPatternDataSummary other = (WorkloadDeploymentPatternDataSummary)obj;
        return Objects.equals(this.deploymentPatternName(), other.deploymentPatternName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.workloadVersionName(), other.workloadVersionName());
    }

    public final String toString() {
        return ToString.builder((String)"WorkloadDeploymentPatternDataSummary").add("DeploymentPatternName", (Object)this.deploymentPatternName()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("WorkloadName", (Object)this.workloadName()).add("WorkloadVersionName", (Object)this.workloadVersionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentPatternName": {
                return Optional.ofNullable(clazz.cast(this.deploymentPatternName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "workloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "workloadVersionName": {
                return Optional.ofNullable(clazz.cast(this.workloadVersionName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("deploymentPatternName", DEPLOYMENT_PATTERN_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("workloadName", WORKLOAD_NAME_FIELD);
        map.put("workloadVersionName", WORKLOAD_VERSION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkloadDeploymentPatternDataSummary, T> g) {
        return obj -> g.apply((WorkloadDeploymentPatternDataSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentPatternName;
        private String description;
        private String displayName;
        private String status;
        private String statusMessage;
        private String workloadName;
        private String workloadVersionName;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkloadDeploymentPatternDataSummary model) {
            this.deploymentPatternName(model.deploymentPatternName);
            this.description(model.description);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.workloadName(model.workloadName);
            this.workloadVersionName(model.workloadVersionName);
        }

        public final String getDeploymentPatternName() {
            return this.deploymentPatternName;
        }

        public final void setDeploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
        }

        @Override
        public final Builder deploymentPatternName(String deploymentPatternName) {
            this.deploymentPatternName = deploymentPatternName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkloadDeploymentPatternStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getWorkloadVersionName() {
            return this.workloadVersionName;
        }

        public final void setWorkloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
        }

        @Override
        public final Builder workloadVersionName(String workloadVersionName) {
            this.workloadVersionName = workloadVersionName;
            return this;
        }

        public WorkloadDeploymentPatternDataSummary build() {
            return new WorkloadDeploymentPatternDataSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkloadDeploymentPatternDataSummary> {
        public Builder deploymentPatternName(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(WorkloadDeploymentPatternStatus var1);

        public Builder statusMessage(String var1);

        public Builder workloadName(String var1);

        public Builder workloadVersionName(String var1);
    }
}

